# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_with_more_info_result


def execute(context):
    """
    获取 isi 下的 dedupe 和 ldap 信息
    :param context: 上下文数据
    """
    data_header = [
        "Name", "Base DN", "Server Uris", "Status", "Alternate Security Identities Attribute", "Authentication",
        "Balance Servers", "Bind DN", "Bind Timeout", "Certificate Authority File", "TLS Protocol Min",
        "Check Online Interval", "CN Attribute", "Create Home Directory", "Crypt Password Attribute",
        "Email Attribute", "Enabled", "Enumerate Groups", "Enumerate Users", "Findable Groups", "Findable Users",
        "GECOS Attribute", "GID Attribute", "Group Base DN", "Group Domain", "Group Filter", "Group Members Attribute",
        "Group Search Scope", "Groupnet", "Home Directory Template", "Homedir Attribute", "Ignore TLS Errors",
        "Listable Groups", "Listable Users", "Login Shell", "Member Lookup Method", "Member Of Attribute",
        "Name Attribute", "Netgroup Base DN", "Netgroup Filter", "Netgroup Members Attribute", "Netgroup Search Scope",
        "Netgroup Triple Attribute", "Normalize Groups", "Normalize Users", "NT Password Attribute", "NTLM Support",
        "Provider Domain", "Require Secure Connection", "Restrict Findable", "Restrict Listable", "Search Scope",
        "Search Timeout", "Shadow User Filter", "Shadow Expire Attribute", "Shadow Flag Attribute",
        "Shadow Inactive Attribute", "Shadow Last Change Attribute", "Shadow Max Attribute", "Shadow Min Attribute",
        "Shadow Warning Attribute", "Shell Attribute", "SSH Public Key Attribute", "UID Attribute",
        "Unfindable Groups", "Unfindable Users", "Unique Group Members Attribute", "Unlistable Groups",
        "Unlistable Users", "User Base DN", "User Domain", "User Filter", "User Search Scope", "Creator Zone"
    ]

    parse_data(context, [data_header], get_domain_ldap_content)


def get_domain_ldap_content(context):
    ldap_key_name = [
        "Name", "Base DN", "Server Uris", "Status", "Alternate Security Identities Attribute", "Authentication",
        "Balance Servers", "Bind DN", "Bind Timeout", "Certificate Authority File", "TLS Protocol Min",
        "Check Online Interval", "CN Attribute", "Create Home Directory", "Crypt Password Attribute",
        "Email Attribute", "Enabled", "Enumerate Groups", "Enumerate Users", "Findable Groups", "Findable Users",
        "GECOS Attribute", "GID Attribute", "Group Base DN", "Group Domain", "Group Filter", "Group Members Attribute",
        "Group Search Scope", "Groupnet", "Home Directory Template", "Homedir Attribute", "Ignore TLS Errors",
        "Listable Groups", "Listable Users", "Login Shell", "Member Lookup Method", "Member Of Attribute",
        "Name Attribute", "Netgroup Base DN", "Netgroup Filter", "Netgroup Members Attribute", "Netgroup Search Scope",
        "Netgroup Triple Attribute", "Normalize Groups", "Normalize Users", "NT Password Attribute", "NTLM Support",
        "Provider Domain", "Require Secure Connection", "Restrict Findable", "Restrict Listable", "Search Scope",
        "Search Timeout", "Shadow User Filter", "Shadow Expire Attribute", "Shadow Flag Attribute",
        "Shadow Inactive Attribute", "Shadow Last Change Attribute", "Shadow Max Attribute", "Shadow Min Attribute",
        "Shadow Warning Attribute", "Shell Attribute", "SSH Public Key Attribute", "UID Attribute",
        "Unfindable Groups", "Unfindable Users", "Unique Group Members Attribute", "Unlistable Groups",
        "Unlistable Users", "User Base DN", "User Domain", "User Filter", "User Search Scope", "Creator Zone"
    ]

    ldap_data = get_key_value_type_with_more_info_result(context, "cmd_display_ldap_list", ":", True)

    ldap_content = []
    index = 0
    while ldap_key_name[0] + str(index) in ldap_data:
        ldap_content.append([ldap_data.get(key + str(index), "-").strip() for key in ldap_key_name])
        index += 1

    return ldap_content
