# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_with_more_info_result


def execute(context):
    """
    获取 isi 下的 dedupe 和 nis 信息
    :param context: 上下文数据
    """
    data_header = [
        "Name", "NIS Domain", "Servers", "Status", "Authentication", "Balance Servers", "Check Online Interval",
        "Create Home Directory", "Enabled", "Enumerate Groups", "Enumerate Users", "Findable Groups", "Findable Users",
        "Group Domain", "Groupnet", "Home Directory Template", "Hostname Lookup", "Listable Groups", "Listable Users",
        "Login Shell", "Normalize Groups", "Normalize Users", "Provider Domain", "NTLM Support", "Request Timeout",
        "Restrict Findable", "Restrict Listable", "Retry Time", "Unfindable Groups", "Unfindable Users",
        "Unlistable Groups", "Unlistable Users", "User Domain", "Ypmatch Using Tcp", "Creator Zone"
    ]

    parse_data(context, [data_header], get_domain_nis_content)


def get_domain_nis_content(context):
    nis_key_name = [
        "Name", "NIS Domain", "Servers", "Status", "Authentication", "Balance Servers", "Check Online Interval",
        "Create Home Directory", "Enabled", "Enumerate Groups", "Enumerate Users", "Findable Groups", "Findable Users",
        "Group Domain", "Groupnet", "Home Directory Template", "Hostname Lookup", "Listable Groups", "Listable Users",
        "Login Shell", "Normalize Groups", "Normalize Users", "Provider Domain", "NTLM Support", "Request Timeout",
        "Restrict Findable", "Restrict Listable", "Retry Time", "Unfindable Groups", "Unfindable Users",
        "Unlistable Groups", "Unlistable Users", "User Domain", "Ypmatch Using Tcp", "Creator Zone"
    ]

    nis_data = get_key_value_type_with_more_info_result(context, "cmd_display_nis_list", ":", True)

    nis_content = []
    index = 0
    while nis_key_name[0] + str(index) in nis_data:
        nis_content.append([nis_data.get(key + str(index), "-").strip() for key in nis_key_name])
        index += 1

    return nis_content
