# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.EMC.nas.parse.zones_parser import get_zone_name_list
from storages.HUAWEI.nas.util.parse_common import parse_data
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取isi 下的 group mapping 信息
    :param context: 上下文数据
    """
    data_header = ["Zone ID", "Zone", "GID", "Group SID"]
    parse_data(context, [data_header], get_group_mapping_content)


def parse_key_value_type_gid_result(cmd_result_lines, separator):
    """
    场景：
    1. 需要遍历完数据
    2. 数据的顺序不固定
    3. 所有的数据都有用
    4. 仅当有key为 "GID" 时生效
    """
    line_val = cmd_result_lines.strip().replace("[", "").replace("]", "").replace("\"", "").split(",")
    data_dict = {}
    uid_flag = False
    for line in line_val:
        if not line:
            continue
        if separator in line:
            separator_index = line.index(separator.strip())
            key = line[0:separator_index].strip()
            value = line[separator_index + 1:]
            if key == "GID":
                uid_flag = True
            data_dict[key] = value
    if uid_flag:
        return data_dict
    else:
        return {}


def parse_key_value_type_result_gid(cmd_result_lines, zone_name, res_content):
    separator = ":"
    # 排除首行
    for line in cmd_result_lines[1:]:
        if separator not in line:
            continue
        data_content = parse_key_value_type_gid_result(line, separator)
        if data_content:
            row_data = [
                data_content.get("ZID"), zone_name, data_content.get("GID"), data_content.get("SID")
            ]
            res_content.append(row_data)


def get_key_value_type_result_gid(context, command, zone_name, res_content):
    result_lines = get_command_result_lines(context, command, True)
    return parse_key_value_type_result_gid(result_lines, zone_name, res_content)


def get_zone_group_mapping_content(context, zone_name, res_content):
    get_share_name_dispaly = "cmd_display_mapping_"
    get_share_name_cmd = get_share_name_dispaly + zone_name
    get_key_value_type_result_gid(context, get_share_name_cmd, zone_name, res_content)


def get_group_mapping_content(context):
    """
    该场景需要先获取zone name，再通过zone name获取对应的数据信息，具体信息格式如下：
    ["ZID:1", "UID:1501", [["SID:S-1-5-21-2069699418-17525152-3091893754-501", 128]]]
    ["ZID:1", "SID:S-1-5-21-2069699418-17525152-3091893754-1104", [["UID:1000002", 32]]]
    ["ZID:1", "GID:1000002", [["SID:S-1-5-21-2069699418-17525152-3091893754-514", 48]]]
    我们需要的内容仅为带有 GID 这一列（总共不止一列）
    将 "[" , "\"", "]" 变成空格符，再通过 "," 对其进行分割
    """
    group_mapping_content = []
    zone_name_list = get_zone_name_list(context)

    for zone_name in zone_name_list:
        get_zone_group_mapping_content(context, zone_name, group_mapping_content)

    return group_mapping_content
