# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.EMC.nas.parse.zones_parser import get_zone_name_list
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_with_more_info_result


def execute(context):
    """
    获取isi 的 group 信息
    :param context: 上下文数据
    """
    data_header = [
        "Zone", "Group ID", "Group Name",
        "DN", "SID", "Domain",
        "Sam Account Name", "Provider", "Generated GID"
    ]
    parse_data(context, [data_header], get_group_content)


def get_zone_group_data(context, zone_name, groups_content):
    group_key_name = ["GID", "Name", "DN", "SID", "Domain", "Sam Account Name", "Provider", "Generated GID"]
    groups_display_cmd = "cmd_display_groups_"

    zones_data = get_key_value_type_with_more_info_result(context, groups_display_cmd + zone_name,
                                                          ":", True)
    index = 0
    while group_key_name[0] + str(index) in zones_data:
        row_data = [zones_data.get(key + str(index).strip(), "-") for key in group_key_name]
        row_data.insert(0, zone_name)
        groups_content.append(row_data)
        index += 1


def get_group_content(context):
    """
    该场景需要先获取zone name，再通过zone name获取指定的group信息
    """

    groups_content = []
    zone_name_list = get_zone_name_list(context)
    for zone_name in zone_name_list:
        get_zone_group_data(context, zone_name, groups_content)

    return groups_content
