# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
from storages.EMC.nas.parse.zones_parser import get_zone_name_list
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_result


def execute(context):
    """
    获取 isi 下的 nfs server 信息
    :param context: 上下文数据
    """
    data_header = [
        "Zone name", "NFSv4 Domain", "NFSv4 Replace Domain", "NFSv4 No Domain",
        "NFSv4 No Domain UIDs", "NFSv4 No Names", "NFSv4 Allow Numeric IDs",
        "NFSv3 Enabled", "NFSv4 Enabled", "NFSv3 RDMA Enabled",
        "Rquota Enabled", "NFS Service Enabled"
    ]
    parse_data(context, [data_header], get_nfs_server_content)


def get_nfs_server_content(context):
    """
    根据 zone 来获取每个的 nfs server 属性
    再把全局的 nfs server 配置 加在每个 zone 后面
    """
    zone_key_name = [
        "NFSv4 Domain", "NFSv4 Replace Domain", "NFSv4 No Domain",
        "NFSv4 No Domain UIDs", "NFSv4 No Names", "NFSv4 Allow Numeric IDs"
    ]
    global_key_name = [
        "NFSv3 Enabled", "NFSv4 Enabled", "NFSv3 RDMA Enabled",
        "Rquota Enabled", "NFS Service Enabled"
    ]
    nfs_server_content = []

    global_nfs_server_data = get_key_value_type_result(context, "cmd_display_nfs_settings_global_view", ":", True)
    zone_name_list = get_zone_name_list(context)
    for zone_name in zone_name_list:
        row_data = [zone_name]
        nfs_server_cmd = "cmd_display_nfs_settings_zone_view_" + zone_name
        zone_nfs_data = get_key_value_type_result(context, nfs_server_cmd, ":", True)
        for key in zone_key_name:
            row_data.append(zone_nfs_data.get(key, "-"))
        for key in global_key_name:
            row_data.append(global_nfs_server_data.get(key, "-"))
        nfs_server_content.append(row_data)
    return nfs_server_content
