# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.EMC.nas.parse.zones_parser import get_zone_name_list
from storages.HUAWEI.nas.util.parse_common import parse_data, get_table_type_cmd_with_more_info_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取isi nfs share 信息
    :param context: 上下文数据
    """
    data_header = [
        "ID", "Zone", "Paths", "Alias",
        "Description", "Clients", "Root Clients",
        "Read Only Clients", "Read Write Clients", "All Dirs",
        "Block Size", "Can Set Time", "Case Insensitive",
        "Case Preserving", "Chown Restricted", "Commit Asynchronous",
        "Directory Transfer Size", "Encoding", "Link Max",
        "Map Lookup UID", "Map Retry", "Security Type",
        "Permission"
    ]
    parse_data(context, [data_header], get_nfs_share_content)


def parse_nfs_share_info_result(cmd_result_lines, separator):
    """
    和 parse_key_value_type_with_more_info_result 相似，但需要排除部分数据
    """
    data_dict = {}
    key = ''
    value = ''
    separator_index = 0
    index = 0
    last_len = 0
    continue_flag = False
    for line in cmd_result_lines[1:]:
        if not line:
            continue
        if line.strip().startswith("Map Root"):
            continue_flag = True
        if line.strip().startswith("Map Full"):
            continue_flag = False
        if continue_flag:
            continue
        if not separator_index and separator in line:
            # 获取分隔符的位置
            separator_index = line.index(separator.strip())
        if len(line) <= separator_index + 2:
            # 排除非法行：短于分隔符位置的行
            continue
        if separator not in line and len(line) > last_len:
            # 排除非法行，没有分隔符且大于上一行，一般来说是多段数据的分割符
            continue
        if separator in line and line.index(separator.strip()) == separator_index:
            # 分隔符位置匹配，是带Key的行，记录当前的Key/Value
            key = line[0:separator_index].strip()
            value = line[separator_index + 2:]
            if key + str(index) in data_dict:
                index += 1
            key = key + str(index)
            data_dict[key] = value
        else:
            # 分隔符位置不匹配，属于上一行Value换行后的内容
            data_dict[key] += line[separator_index + 2:]
        last_len = len(line)
    if key:
        key = key + str(index)
        data_dict[key] = value
    return data_dict


def get_nfs_share_info_result(context, command, separator, with_blank=True):
    result_lines = get_command_result_lines(context, command, with_blank=with_blank)
    return parse_nfs_share_info_result(result_lines, separator)


def get_alias_map(context, zone_name):
    get_alias_display = "cmd_display_nfs_aliases_list_" + zone_name
    alias_info = get_table_type_cmd_with_more_info_result(context, get_alias_display)
    alias_map = {}
    for item in alias_info:
        alias_map[item.get("Path")] = item.get("Name")
    return alias_map


def get_zone_nfs_share_content(context, zone_name, nfs_share_content):
    """
    Permission 是通过 Read Only 这个key来进行判断的
    Alias 需要通过 Zone 和 Path 对 Alias 进行匹配，如果有同时符合的则是对应的别名
    该 Key 取值为 Read/Write 或者 Read
    """
    nfs_share_key_name_bef = [
        "ID", "Zone", "Paths"
    ]
    nfs_share_key_name_aft = [
        "Description", "Clients", "Root Clients",
        "Read Only Clients", "Read Write Clients", "All Dirs",
        "Block Size", "Can Set Time", "Case Insensitive",
        "Case Preserving", "Chown Restricted", "Commit Asynchronous",
        "Directory Transfer Size", "Encoding", "Link Max",
        "Map Lookup UID", "Map Retry", "Security Type"
    ]
    get_share_name_dispaly = "cmd_display_nfs_exports_"
    get_share_name_cmd = get_share_name_dispaly + zone_name
    name_data = get_nfs_share_info_result(context, get_share_name_cmd, ":", True)
    alist_map = get_alias_map(context, zone_name)
    index = 0
    while nfs_share_key_name_bef[0] + str(index) in name_data:
        row_data = [name_data.get(key + str(index), "-") for key in nfs_share_key_name_bef]
        row_data.append(alist_map.get(row_data[-1].strip(), ""))
        for key in nfs_share_key_name_aft:
            row_data.append(name_data.get(key + str(index), "-").strip())
        if name_data.get("Read Only" + str(index)):
            row_data.append("Read/Write" if name_data.get("Read Only" + str(index)).startswith("No") else "Read")
        nfs_share_content.append(row_data)
        index += 1


def get_nfs_share_content(context):
    """
    该场景是先通过获取 zone name 再通过 对具体信息进行解析
    具体信息格式较为复杂，部分有固定分隔符且可能有多行，但是中间参杂了非固定分隔符的数据
    解析时需要先排除异常格式部分再进行解析（该部分内暂无可用信息）
    """
    nfs_share_content = []
    zone_name_list = get_zone_name_list(context)

    for zone_name in zone_name_list:
        get_zone_nfs_share_content(context, zone_name, nfs_share_content)
    return nfs_share_content
