# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, get_table_type_cmd_with_more_info_result


def execute(context):
    """
    获取isi 的 nic 信息
    :param context: 上下文数据
    """
    data_header = ["Name", "LNN", "Status", "VLAN ID", "Owners", "Owner Type", "IP Address"]
    parse_data(context, [data_header], get_nic_content)


def get_nic_content(context):
    """
    该命令格式如下：
    LNN  Name     Status     VLAN ID  Owners                              Owner Type  IP Addresses
    4    10gige-1 Up         502      groupnet0.subnet_prod               SSIP        127.0.0.1
                                      groupnet0.subnet_prod.pool_data     Dynamic     127.0.0.1
                                                                                      127.0.0.1
    我们需要解析成2个，下面两行是一个数据列，第一行是一个数据列。
    只有IP的属于上一列的数据，有Owners的单独开另一列，但是省略的数据按上一行的数据列来，即和下面等效：
    4    10gige-1 Up         502      groupnet0.subnet_prod               SSIP        127.0.0.1
    4    10gige-1 Up         502      groupnet0.subnet_prod.pool_data     Dynamic     127.0.0.1，127.0.0.1
    """
    nic_key_name = ["Name", "LNN", "Status", "VLAN ID", "Owners", "Owner Type"]
    nic_data = get_table_type_cmd_with_more_info_result(context, "cmd_display_network_interfaces", True)
    index = 0
    res_data = []
    # 这里是提前做一次排查，如果有Owners就另开一列数据存放
    for item in nic_data:
        if len(item.get("Owners")):
            item["nextFlag"] = True
        else:
            item["nextFlag"] = False

    while index < len(nic_data):
        row_data = []
        # 复制省略的数据
        for key_index, key in enumerate(nic_key_name):
            if not nic_data[0].get(key):
                row_data.append("-")
                continue
            if not nic_data[index].get(key):
                nic_data[index][key] = res_data[-1][key_index]
            row_data.append(nic_data[index].get(key, "-"))
        ip_data = nic_data[index].get("IP Addresses")
        # 排查非法行，如最后一行会有Total: xx
        if not nic_data[index].get("IP Addresses"):
            index += 1
            continue
        # 通过此前设计的标记来判断是否存在下一行
        while index < len(nic_data) - 1:
            if nic_data[index + 1].get("Owners") or nic_data[index + 1].get("Name"):
                break
            else:
                ip_data = ip_data + ", " + nic_data[index + 1].get("IP Addresses")
            index += 1
        row_data.append(ip_data)
        res_data.append(row_data)
        index += 1
    return res_data
