# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data,\
    get_key_value_type_with_more_info_result


def execute(context):
    """
    获取isi 下的 nic pool 信息
    :param context: 上下文数据
    """
    data_header = [
        "ID", "Groupnet", "Subnet", "Name", "Rules",
        "Access Zone", "Allocation Method", "Aggregation Mode",
        "SC Suspended Nodes", "Description", "Ifaces", "IP Ranges",
        "Rebalance Policy", "SC Auto Unsuspend Delay", "SC Connect Policy",
        "SC Zone", "SC DNS Zone Aliases", "SC Failover Policy", "SC Subnet",
        "SC TTL", "Static Routes", "NFSv3 RDMA RRoCE only"
    ]
    parse_data(context, [data_header], get_nic_pool_content)


def get_nic_pool_content(context):
    """
    该命令格式可能有多个数据存在，且每个数据内分隔符不一致
    这里我们在取的时候就已经每个加了末尾编号0,1,2...
    所以我们取的时候也按末尾编号来，并通过判断第一个，比如 Name0 是否存在来判断 0 号组是否存在
    """
    nic_pool_key_name = [
        "ID", "Groupnet", "Subnet", "Name", "Rules",
        "Access Zone", "Allocation Method", "Aggregation Mode",
        "SC Suspended Nodes", "Description", "Ifaces", "IP Ranges",
        "Rebalance Policy", "SC Auto Unsuspend Delay", "SC Connect Policy",
        "SC Zone", "SC DNS Zone Aliases", "SC Failover Policy", "SC Subnet",
        "SC TTL", "Static Routes", "NFSv3 RDMA RRoCE only"
    ]
    nic_pool_content = []
    nic_pool_data = get_key_value_type_with_more_info_result(context, "cmd_display_network_pools_verbose",
                                                          ":", True)
    index = 0
    while nic_pool_key_name[0] + str(index) in nic_pool_data:
        nic_pool_content.append([nic_pool_data.get(key + str(index), "-") for key in nic_pool_key_name])
        index += 1
    return nic_pool_content
