# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_result, \
    get_key_value_type_with_no_fixed_separator_result


def execute(context):
    """
    获取isi 系统总览信息
    :param context: 上下文数据
    """
    data_header = [
        "Type", "Vendor", "Model", "Product Model",
        "System Name", "IP", "Version", "SN",
        "Cluster Health", "Current Encoding"
    ]
    parse_data(context, [data_header], get_overview_content)


def get_overview_content(context):
    dev_type = context.get("dev_type")
    dev_vendor = context.get("dev_vendor")
    dev_model = context.get("dev_model")
    dev_ip = context.get("ip")
    config_data = get_key_value_type_with_no_fixed_separator_result(context, "cmd_display_config",
                                                                    ":", False)
    node_build_data = config_data.get("Node build")
    clustr_line = get_key_value_type_with_no_fixed_separator_result(context, "cmd_display_cluster_status",
                                                                    ":", False)
    ending_data = get_key_value_type_result(context, "cmd_display_encoding_settings", ":", False)
    # node_build_data 的格式构成为 Isilon OneFS 9.2.1.11 B_9_2_1_002(RELEASE)
    # 取 OneFS 和 9.2.1.11 作为 Product Model和 Version,即 node_build_data.split()[1]和 node_build_data.split()[2]
    # "Cluster Health" 一般值为    [ xx ]  只获取中间的值（两边有空格）
    row_data = [
        dev_type, dev_vendor, dev_model, node_build_data.split()[1], clustr_line.get("Cluster Name"), dev_ip,
        node_build_data.split()[2], config_data.get("Node serial number"),
        clustr_line.get("Cluster Health").strip().strip('[').strip(']').strip(),
        ending_data.get("Current Encoding")
    ]
    return [row_data]
