# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data,\
    get_key_value_type_with_more_info_result


def execute(context):
    """
    获取isi 下的 snapshot 信息
    :param context: 上下文数据
    """
    data_header = [
        "ID", "Name", "Path", "Has Locks", "Schedule",
        "Alias Target ID", "Created", "Expires", "Size",
        "Shadow Bytes", "% Reserve", "% Filesystem", "State"
    ]
    parse_data(context, [data_header], get_snapshot_content)


def get_snapshot_content(context):
    """
    该命令格式可能有多个数据存在，且每个数据内分隔符一致
    这里我们在取的时候就已经每个加了末尾编号0,1,2...
    所以我们取的时候也按末尾编号来，并通过判断第一个，比如 Name0 是否存在来判断 0 号组是否存在
    """
    snap_key_name = [
        "ID", "Name", "Path", "Has Locks", "Schedule",
        "Alias Target ID", "Created", "Expires", "Size",
        "Shadow Bytes", "% Reserve", "% Filesystem", "State"
    ]
    
    snapshot_content = []
    zones_data = get_key_value_type_with_more_info_result(context, "cmd_display_snapshots",
                                                          ":", True)
    index = 0
    while snap_key_name[0] + str(index) in zones_data:
        snapshot_content.append([zones_data.get(key + str(index), "-") for key in snap_key_name])
        index += 1
    return snapshot_content
