# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data,\
    get_key_value_type_with_no_fixed_separator_and_more_info_result


def execute(context):
    """
    获取isi 的 storage_pools 信息
    :param context: 上下文数据
    """
    data_header = [
        "Storage Pool Name", "Type", "Children",
        "HDD Total", "HDD Used", "HDD % Used",
        "SSD Total", "SSD Used", "SSD % Used",
        "Nodes", "Requested Protection"
    ]
    parse_data(context, [data_header], get_storage_pools_content)


def get_storage_pools_content(context):
    """
    该命令格式可能有多个数据存在，且每个数据内分隔符不一致
    这里我们在取的时候就已经每个加了末尾编号0,1,2...
    所以我们取的时候也按末尾编号来，并通过判断第一个，比如 Name0 是否存在来判断 0 号组是否存在
    """
    storage_pool_key_name = [
        "Name", "Type", "Children",
        "HDD Total", "HDD Used", "HDD % Used",
        "SSD Total", "SSD Used", "SSD % Used",
        "Nodes", "Requested Protection"
    ]
    storage_content = []
    storage_data = get_key_value_type_with_no_fixed_separator_and_more_info_result(context,
                                                                                   "cmd_display_storagepool_list",
                                                                                   ":", True)
    index = 0
    while storage_pool_key_name[0] + str(index) in storage_data:
        storage_content.append([storage_data.get(key + str(index), "-") for key in storage_pool_key_name])
        index += 1
    return storage_content
