# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.EMC.nas.parse.zones_parser import get_zone_name_list
from storages.HUAWEI.nas.util.parse_common import parse_data, \
    get_key_value_type_with_no_fixed_separator_and_more_info_result


def execute(context):
    """
    获取isi 下的 zone 信息
    :param context: 上下文数据
    """
    data_header = [
        "Zone", "User Name", "DN", "DNS Domain", "Domain",
        "Provider", "Sam Account Name", "UID",
        "SID", "Enabled", "Primary Group ID", "Primary Group Name"
    ]
    parse_data(context, [data_header], get_user_content)


def get_zone_user_data(context, zone_name, user_content):
    """
    user 格式较为复杂，存在非固定分隔符，且有多段数据，每段数据内也存在同名数据，如下：
    --------------------------------------------------------------------------------
                        Name: nobody
                         SID: S-1-22-1-65534
               Primary Group
                              ID: GID:65534
                            Name: nobody
              Home Directory: /nonexistent
    User Can Change Password: No
    中间的 Primary Group 存在数据，但是目前是按只会存在一个数据解析的
    对于这种情况，我们将数据分为了两段，一段是重名Name以前的，按照解析逻辑
    上面会是{Name0, SID0, ID0}
    从 Name 开始，则是{Name1, Home Directory1, User Can Change Password1}
    即每段数据拥有两个编号，第二个编号是从重名的 Name 开始的
    我们先解析上面数据，再将编号 + 1 来查询剩下的数据，即每段数据会把编号 + 2
    """
    user_display = "cmd_display_users_"
    user_key_name = [
        "Name", "DN", "DNS Domain", "Domain",
        "Provider", "Sam Account Name", "UID",
        "SID", "Enabled", "ID"
    ]

    user_zone_display = user_display + zone_name
    user_data = get_key_value_type_with_no_fixed_separator_and_more_info_result(context, user_zone_display,
                                                                                ":", False)
    index = 0
    while user_key_name[0] + str(index) in user_data:
        row_data = [user_data.get(key + str(index), "-") for key in user_key_name]
        row_data.insert(0, zone_name)
        index += 1
        row_data.append(user_data.get("Name" + str(index), "-"))
        user_content.append(row_data)
        index += 1


def get_user_content(context):
    """
    需要先获取 zone_name_list ，再通过 zone_name 查询对应的 user信息
    """
    user_content = []
    zone_name_list = get_zone_name_list(context)

    for zone_name in zone_name_list:
        get_zone_user_data(context, zone_name, user_content)

    return user_content
