# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, \
    get_key_value_type_with_more_info_result, get_key_value_type_result


def execute(context):
    """
    获取isi 下的 worm 信息
    :param context: 上下文数据
    """
    data_header = [
        "Path", "ID", "Type",
        "LIN", "Autocommit Offset", "Override Date",
        "Privileged Delete", "Default Retention",
        "Min Retention", "Max Retention", "Pending Delete",
        "Exclusions", "Compliance Clock"
    ]
    parse_data(context, [data_header], get_worm_content)


def get_worm_content(context):
    """
    该命令格式可能有多个数据存在，且每个数据内分隔符不一致
    这里我们在取的时候就已经每个加了末尾编号0,1,2...
    所以我们取的时候也按末尾编号来，并通过判断第一个，比如 Name0 是否存在来判断 0 号组是否存在
    Compliance Clock 是全局属性
    """
    worm_key_name = [
        "Path", "ID", "Type",
        "LIN", "Autocommit Offset", "Override Date",
        "Privileged Delete", "Default Retention",
        "Min Retention", "Max Retention",
        "Pending Delete", "Exclusions"
    ]
    worm_content = []
    worm_data = get_key_value_type_with_more_info_result(context, "cmd_display_worm_domains",
                                                          ":", True)
    cdate_data = get_key_value_type_result(context, "cmd_display_worm_cdate", ":", False)

    index = 0
    while worm_key_name[0] + str(index) in worm_data:
        row_data = [worm_data.get(key + str(index), "-").strip() for key in worm_key_name]
        row_data.append(cdate_data.get("Compliance Clock", "-"))
        worm_content.append(row_data)
        index += 1
    return worm_content
