# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data,\
    get_key_value_type_with_more_info_result


def execute(context):
    """
    获取isi 下的 zone 信息
    :param context: 上下文数据
    """
    data_header = [
        "Zone Name", "Zone ID", "Path",
        "Groupnet", "Map Untrusted", "Auth Providers",
        "NetBIOS Name", "User Mapping Rules", "Home Directory Umask",
        "Skeleton Directory", "Cache Entry Expiry", "Negative Cache Entry Expiry"
    ]
    parse_data(context, [data_header], get_zones_content)


def get_zones_content(context):
    """
    该命令格式可能有多个数据存在，且每个数据内分隔符不一致
    这里我们在取的时候就已经每个加了末尾编号0,1,2...
    所以我们取的时候也按末尾编号来，并通过判断第一个，比如 Name0 是否存在来判断 0 号组是否存在
    """
    zone_key_name = [
        "Name", "Zone ID", "Path",
        "Groupnet", "Map Untrusted", "Auth Providers",
        "NetBIOS Name", "User Mapping Rules", "Home Directory Umask",
        "Skeleton Directory", "Cache Entry Expiry", "Negative Cache Entry Expiry"
    ]
    zones_content = []
    zones_data = get_key_value_type_with_more_info_result(context, "cmd_display_zones_list_verbose",
                                                          ":", True)
    index = 0
    while zone_key_name[0] + str(index) in zones_data:
        zones_content.append([zones_data.get(key + str(index), "-").strip() for key in zone_key_name])
        index += 1
    return zones_content


def get_zone_name_list(context):
    zones_content = get_zones_content(context)
    return [item[0] for item in zones_content]
