#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from common.cmd_execute import DES, CMD, change_list_to_tuple
from storages.EMC.nas.emc_isilon import EmcIsilon

CMD_LIST = [
    {DES: "cmd_display_dedupe_settings", CMD: "isi dedupe settings view"},
    {DES: "cmd_display_dedupe_stats", CMD: "isi dedupe stats"},
    {DES: "cmd_display_sync_jobs", CMD: "isi sync jobs list --verbose"},
    {DES: "cmd_display_snapshots", CMD: "isi snapshot snapshots list --verbose"},
    {DES: "cmd_display_antivirus_settings", CMD: "isi antivirus settings view"},
    {DES: "cmd_display_antivirus_servers", CMD: "isi antivirus servers list"},
    {DES: "cmd_display_antivirus_policies", CMD: "isi antivirus policies list"},
    {DES: "cmd_display_ndmp_settings_global", CMD: "isi ndmp settings global view"},
    {DES: "cmd_display_ndmp_settings_variables", CMD: "isi ndmp settings variables list"},
    {DES: "cmd_display_worm_domains", CMD: "isi worm domains list --verbose"},
    {DES: "cmd_display_worm_cdate", CMD: "isi worm cdate view"},
    {DES: "cmd_display_ftp_view", CMD: "isi ftp view"},
    {DES: "cmd_display_http_view", CMD: "isi http view"},
    {DES: "cmd_display_hdfs_settings", CMD: "isi hdfs settings view"},
    {DES: "cmd_display_swift_accounts", CMD: "isi swift accounts list --verbose"},
    {DES: "cmd_display_tape_list", CMD: "isi tape list"},
    {DES: "cmd_display_audit_settings_global", CMD: "isi audit settings global view"},
    {DES: "cmd_display_audit_progress_global", CMD: "isi audit progress global view"},
]

ZONE_NAME_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_audit_settings_", CMD: "isi audit settings view --zone=%s"},
]

POLICY_NAME_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_antivirus_policies_", CMD: "isi antivirus policies view %s"},
]


class ValueServiceInfoEmcIsilon(EmcIsilon):
    def __init__(self, context):
        EmcIsilon.__init__(self, context)

    def execute(self):
        self.cmd_list = CMD_LIST
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_zone_name_list()), ZONE_NAME_RELATIVE_CMD_DICTS)
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_policy_name_list()),
                                        POLICY_NAME_RELATIVE_CMD_DICTS)
        self.execute_pure_cmd_list(True)
