#  coding=UTF-8
#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from storages.EMC.emc_storage_util import ERR_MSG
from storages.EMC.emc_storage_util import get_rest_result_message
from storages.EMC.unity.emc_unity_util import PAGE1_PARAM
from storages.EMC.unity.emc_unity_util import get_next_page_param

system_info_api_key = 'cmd_display_system_info'
system_info_api = 'system/instances?fields=id,model,serialNumber'

basic_system_info_api_key = 'cmd_display_basic_system_info'
basic_system_info_api = 'basicSystemInfo/instances?fields=softwareVersion'

host_info_api_key = 'cmd_display_host_info'
host_info_api = 'host/instances?fields=id,name,osType,fcHostInitiators,hostLUNs'

initiator_info_api_key = 'cmd_display_initiator_info'
initiator_info_api = 'hostInitiator/instances?fields=id,portWWN'

lun_info_api_key = 'cmd_display_lun_info'
lun_info_api = 'lun/instances?fields=id,health,name,sizeTotal,isThinEnabled,wwn'


def get_unity_system_info(context):
    """
    获取系统信息
    :param context: 上下文
    :return: 采集结果
    """
    get_unity_info(context, system_info_api_key, system_info_api)
    return get_unity_info(context, basic_system_info_api_key, basic_system_info_api)


def get_unity_host_info(context):
    """
    获取主机信息
    :param context: 上下文
    :return: 采集结果
    """
    get_unity_info(context, host_info_api_key, host_info_api)
    return get_unity_info(context, initiator_info_api_key, initiator_info_api)


def get_unity_lun_info(context):
    """
    获取LUN信息
    :param context: 上下文
    :return: 采集结果
    """
    return get_unity_info(context, lun_info_api_key, lun_info_api)


def get_unity_info(context, api_key, api):
    """
    获取Unity信息
    :param context: 上下文
    :param api_key: 接口Key
    :param api: 接口
    :return:
    """
    rest = context.get("SSH")
    language = context.get("lang")
    cmd_display = context.get("ret_map")
    error_msg = cmd_display.get(ERR_MSG, "")
    next_page_param = PAGE1_PARAM
    while next_page_param:
        response = rest.sendRestWithoutLog("GET", api + next_page_param, "")
        cmd_display.put(api_key + next_page_param, response)
        error_msg += get_rest_result_message(api + next_page_param, response, language)
        next_page_param = get_next_page_param(response)
    cmd_display.put(ERR_MSG, error_msg)
    return cmd_display
