#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import json

PER_PAGE_PARAM = "&per_page=2000%s"
PAGE1_PARAM = PER_PAGE_PARAM % "&page=1"


def get_next_page_param(rest_response):
    """
    Unity接口回显中，若批量接口有下一页，会在“links”字段中，存在“rel”值为“next”的项
    找到“next”后，返回“href”值，为下一页的参数
    :param rest_response:
    :return:
    """
    json_data = json.loads(rest_response)
    links = json_data.get("links", [])
    for link in links:
        if link.get("rel", "") == "next" and "href" in link:
            return PER_PAGE_PARAM % link["href"]
    return ""


def get_rest_contents(rest_response):
    """
    从Rest回显Json数据中获取“content”字段数据
    Unity接口回显的数据，均在content字段中，存在多个content字段
    :param rest_response: Rest回显Json数据
    :return: content数据集合
    """
    json_data = json.loads(rest_response)
    entries = json_data.get("entries", [])
    contents = []
    for entry in entries:
        content = entry.get("content", {})
        if content:
            contents.append(content)
    return contents
