#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from storages.EMC.emc_storage_util import NA
from storages.EMC.emc_storage_util import get_command_result_lines
from storages.EMC.unity.emc_unity_util import PAGE1_PARAM
from storages.EMC.unity.emc_unity_util import get_rest_contents, get_next_page_param


def analysis_host_lun_map(host_contents):
    """
    解析主机LUN映射关系
    使用字典来唯一定位映射相同LUN的主机，实现映射视图的整理
    使用元组数组来保证顺序不发生改变，从而确保主机解析和LUN解析时，映射顺序一致
    :param host_contents: 主机信息集合
    :return: 映射信息元组集合(主机ID集合，LUN ID集合)
    """
    host_lun_map = {}
    map_groups = []
    for host_content in host_contents:
        lun_ids = get_lun_id(host_content)
        host_lun_key = ",".join(lun_ids) if lun_ids else host_content.get("id", NA)
        if host_lun_key not in host_lun_map:
            map_group = ([], lun_ids)
            map_groups.append(map_group)
            host_lun_map[host_lun_key] = map_group
        host_id = host_content.get("id", "Host_NA")
        host_lun_map[host_lun_key][0].append(host_id)
    return map_groups


def get_lun_id(host_content):
    """
    获取LUN ID集合
    先从主机信息中获取host_lun_id集合，再解析出lun_id集合
    host_lun_id示例：Host_1_sv_2_prod，其中sv_2代表LUN ID，只取2
    :param host_content: 主机信息
    :return: lun_ids
    """
    lun_ids = []
    host_lun_ids = get_host_lun_id(host_content)
    for host_lun_id in host_lun_ids:
        lun_ids.append("sv_" + host_lun_id.split("_")[3])
    lun_ids.sort()
    return lun_ids


def get_host_lun_id(host_content):
    """
    获取主机LUN ID集合
    :param host_content: 主机信息
    :return: 主机LUN ID集合
    """
    host_lun_ids = []
    host_luns = host_content.get("hostLUNs", [])
    for host_lun in host_luns:
        host_lun_id = host_lun.get("id", "")
        if host_lun_id:
            host_lun_ids.append(host_lun_id)
    return host_lun_ids


def get_contents(context, api_key):
    """
    获取接口所有的信息
    :param context: 上下文
    :param api_key: 接口Key
    :return: 所有信息
    """
    page_param = PAGE1_PARAM
    contents = []
    while page_param:
        response = "".join(get_command_result_lines(context, api_key + page_param))
        contents.extend(get_rest_contents(response))
        page_param = get_next_page_param(response)
    return contents
