#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
import re
import json
from common.contentParse import getValueFMap, addValueToMap, get_jsonstr, get_attrcom_dicv2, get_attrvalue_dic, \
    get_jsonarr_name, style, divide
from storages.EMC.emc_storage_util import NA, EMC_VNX, EMC_VMAX, EMC_VPLEX, EMC_UNITY
from storages.EMC.emc_storage_util import check_vmax_json, get_vplex_all_objects
from storages.EMC.unity.unity_lun_info_parser import parse_unity_lun_info


# 对应excel中的属性字段
key_lst = [
    'mapping_view_id', 'mapping_view_name', 'lun_group_id',
    'lun_group_name', 'lun_id', 'lun_name', 'capacity',
    'host_id', 'hostgroup_id', 'status', 'lun_wwn', 'lun_type'
]
lun_gp_name_prefix = "LunGroup%03d"


def execute(context):
    """

    :param context:
    :return:
    """
    command = getValueFMap(context, style, 'command').strip()
    addValueToMap(context, style, 'command', command)
    # 属性名与对应命令列表组成的字典
    attrcom_dic = get_attrcom_dicv2(context)
    # 对应execel属性名
    json_attr_name = get_jsonarr_name(attrcom_dic)
    attr_valuelst_dic = get_attrvalue_dic(context, attrcom_dic)
    # 获取attribute ,value_lst
    attribute_arr = []
    for key in key_lst:
        for attr in attr_valuelst_dic.keys():
            if key.lower().strip() in attr.lower():
                attribute_arr.append(attr)

    # 获取storage gp 回文
    sg_value_lst = attr_valuelst_dic[attribute_arr[1]]

    dev_model = getValueFMap(context, style, 'dev_model').strip()
    if dev_model == EMC_VNX:
        report_path = getValueFMap(context, style, 'path')
        # 获取传入的mapping view　id
        mapping_view_id = attrcom_dic['mapping_view_id'][0].strip()
        value_lst = get_vnx_value_lst(mapping_view_id, report_path, sg_value_lst)
    elif dev_model == EMC_VMAX:
        # storageGroup信息
        sg_cfg_lst = attr_valuelst_dic[attribute_arr[3]]
        # 设备基本信息
        serial_lst = attr_valuelst_dic[attribute_arr[4]]
        # 设备卷信息
        volume_value_lst = attr_valuelst_dic[attribute_arr[5]]
        value_lst = get_vmax_value_lst(sg_value_lst, volume_value_lst,
                                       serial_lst, sg_cfg_lst)
    elif dev_model == EMC_VPLEX:
        value_lst = get_vplex_value_lst(context)
    elif dev_model == EMC_UNITY:
        value_lst = parse_unity_lun_info(context)
    else:
        value_lst = [NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA]
    # 获取json结果字符串
    result = get_jsonstr(json_attr_name, attribute_arr, value_lst)
    addValueToMap(context, style, 'result', result)
    return context


def get_vplex_value_lst(context):
    """
    获取Vplex LUN映射信息
    :param context: 映射信息
    :return: 设备信息
    """
    storage_view_dicts = get_vplex_all_objects(context, "cmd_display_storage_views_")
    lun_entities = []
    storage_view_id = 0
    for storage_view_dict in storage_view_dicts:
        storage_view_id += 1
        storage_view_name = storage_view_dict.get("name", "")
        lun_gp_name = "LunGroup%03d" % storage_view_id
        lun_infos = storage_view_dict.get("virtual-volumes", [])
        # 映射中无LUN时，添加空白LUN信息，以让表格可展示映射中主机信息
        if not lun_infos:
            lun_entity = LunEntity()
            lun_entity.set_gp_id(str(storage_view_id))
            lun_entity.set_mapping_name(storage_view_name)
            lun_entities.append(lun_entity)
            continue
        for lun_info in lun_infos:
            lun_info_items = lun_info.strip("()").split(",")
            if len(lun_info_items) < 4:
                continue
            lun_entity = LunEntity()
            lun_entity.set_gp_id(str(storage_view_id))
            lun_entity.set_mapping_name(storage_view_name)
            lun_entity.set_lun_gp_name(lun_gp_name)
            lun_entity.set_id(lun_info_items[0])
            lun_entity.set_name(lun_info_items[1])
            lun_entity.set_wwn(lun_info_items[2].split(":")[-1])
            lun_entity.set_capacity(lun_info_items[3] + "B")
            lun_entities.append(lun_entity)
    return trans_lun_to_val_lst(lun_entities)


def get_vmax_value_lst(sg_value_lst, lun_value_lst, serial_lst, sg_cfg_lst):
    """
    获取VMAX LUN映射信息
    :param sg_value_lst: 映射信息
    :param lun_value_lst: LUN信息
    :param serial_lst: 设备信息
    :param sg_cfg_lst: storageGroup信息
    :return: value_lst
    """
    serial = get_serial_number(serial_lst)
    mv_map = get_masking_view_map(sg_value_lst, sg_cfg_lst)
    lun_entities = get_lun_entity_lst(lun_value_lst, mv_map, serial)
    return trans_lun_to_val_lst(lun_entities)


def trans_lun_to_val_lst(lun_entity_lst):
    if bool(lun_entity_lst):
        value_lst = []
        for lun_entity in lun_entity_lst:
            value_lst.append(lun_entity.get_gp_id())
            value_lst.append(lun_entity.get_mapping_name())
            value_lst.append(NA)
            value_lst.append(lun_entity.get_lun_gp_name())
            value_lst.append(lun_entity.get_id())
            value_lst.append(lun_entity.get_name())
            value_lst.append(lun_entity.get_capacity())
            value_lst.append(lun_entity.get_host_id())
            value_lst.append(NA)
            value_lst.append(lun_entity.get_status())
            value_lst.append(lun_entity.get_wwn())
            value_lst.append(lun_entity.get_type())
    else:
        value_lst = [NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA]
    return value_lst


def get_lun_entity_lst(volume_value_lst, mv_map, serial):
    lun_entity_lst = []
    lg_entities = get_lg_entities(volume_value_lst, serial)
    gp_id = 0
    last_mv_name = NA
    for mv_entry in mv_map:
        mv_name = mv_entry[0]
        if last_mv_name == NA or mv_name != last_mv_name:
            gp_id += 1
            last_mv_name = mv_name
        lg_name = mv_entry[1]
        if lg_name != NA and lg_name in lg_entities:
            for entity in lg_entities[lg_name]:
                lun_entity = copy_lun_entity(entity)
                lun_entity.set_mapping_name(mv_name)
                lun_entity.set_gp_id(str(gp_id))
                lun_entity.set_lun_gp_name(lg_name)
                lun_entity_lst.append(lun_entity)
    return lun_entity_lst


def copy_lun_entity(lun_entity):
    new_entity = LunEntity()
    new_entity.set_mapping_name(lun_entity.get_mapping_name())
    new_entity.set_gp_id(lun_entity.get_gp_id())
    new_entity.set_lun_gp_name(lun_entity.get_lun_gp_name())
    new_entity.set_id(lun_entity.get_id())
    new_entity.set_name(lun_entity.get_name())
    new_entity.set_capacity(lun_entity.get_capacity())
    new_entity.set_host_id(lun_entity.get_host_id())
    new_entity.set_wwn(lun_entity.get_wwn())
    new_entity.set_type(lun_entity.get_type())
    new_entity.set_status(lun_entity.get_status())
    return new_entity


def get_lg_entities(lun_value_lst, serial):
    lg_entities = {}
    n_a = "N/A"
    for line in lun_value_lst:
        if check_vmax_json(line):
            lun_json = json.loads(line).get("volume", [{}])[0]
            lg_names = lun_json.get("storageGroupId")
            if lg_names is None:
                continue
            lun_entity = get_vmax_lun_entity(lun_json, n_a, serial)
            for lg_name in lg_names:
                if lg_name not in lg_entities:
                    lg_entities[lg_name] = []
                lg_entities[lg_name].append(lun_entity)
    return lg_entities


def get_vmax_lun_entity(lun_json, n_a, serial):
    lun_id = lun_json.get("volumeId", NA)
    lun_type = lun_json.get("type", NA)
    capacity = str(lun_json.get("cap_mb", NA)) + "MB"
    status = lun_json.get("status", NA)
    wwn = lun_json.get("wwn", NA)
    lun_name = lun_json.get("volume_identifier", n_a)
    if lun_name == n_a:
        lun_name = "LUN_" + serial
    if len(lun_name) > 24:
        lun_name = lun_name[0:24]
    lun_name += "_" + lun_id
    lun_entity = LunEntity()
    lun_entity.set_id(str(int(lun_id, 16)))
    lun_entity.set_name(lun_name)
    lun_entity.set_capacity(capacity)
    lun_entity.set_status(status)
    lun_entity.set_wwn(wwn)
    lun_entity.set_type(lun_type)
    return lun_entity


def get_masking_view_map(sg_value_lst, sg_cfg_lst):
    """
    解析maskingView信息
    :param sg_value_lst: maskingView info
    :param sg_cfg_lst: storageGroup info
    :return: [(mv_name, sg_name), ...]
    """
    sg_child_map = get_sg_child_map(sg_cfg_lst)
    mv_map = []
    if not bool(sg_value_lst):
        return mv_map
    for line in sg_value_lst:
        if not check_vmax_json(line):
            continue
        mv_json = json.loads(line).get("maskingView", [{}])[0]
        mv_name = mv_json.get("maskingViewId", NA)
        sg_name = mv_json.get("storageGroupId", NA)
        if sg_name in sg_child_map:
            for child_sg in sg_child_map[sg_name]:
                mv_map.append((mv_name, child_sg))
        else:
            mv_map.append((mv_name, sg_name))
    return mv_map


def get_sg_child_map(sg_cfg_lst):
    sg_child_map = {}
    for line in sg_cfg_lst:
        if check_vmax_json(line):
            sg_cfg_json = json.loads(line)
            child_sgs = sg_cfg_json.get("child_storage_group", [])
            if bool(child_sgs):
                sg_child_map[sg_cfg_json.get("storageGroupId", NA)] = child_sgs
    return sg_child_map


def get_serial_number(serial_lst):
    serial_no = EMC_VMAX
    for line in serial_lst:
        if check_vmax_json(line):
            sn_json = json.loads(line).get("symmetrix", [{}])[0]
            serial_no = sn_json.get("symmetrixId", NA)
            break
    return serial_no


def get_vnx_value_lst(mapping_view_id, report_path, sg_value_lst):
    """
    VNX: 根据storage gp 回文获取 storate gp bean集合
    :param mapping_view_id: 传入的映射视图ID
    :param report_path: 报告文件路径
    :param sg_value_lst: storage group信息
    :return: value_lst
    """
    storage_lst = get_storage_group_lst(sg_value_lst)
    storage_bean_lst = get_storage_bean_lst(storage_lst)

    mapping_view_name = NA
    temp_storage_gp = StorageGroupEntity()
    # 求mapping_view_name ,temp_storage_gp
    for storage_bean in storage_bean_lst:
        if mapping_view_id == storage_bean.get_uid():
            mapping_view_name = storage_bean.get_name()
            temp_storage_gp = storage_bean
            break
    # alu_temp_lst
    alu_temp_lst = temp_storage_gp.get_alulst()
    if not bool(alu_temp_lst):
        value_lst = [NA, mapping_view_name, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA]
    else:
        value_lst = []
        for alu_num in alu_temp_lst:
            cmd_display = "cmd_display_storage_" + mapping_view_name + \
                          "_alu" + alu_num
            alu_egg = get_lun_entity(cmd_display, report_path, alu_num)
            value_lst.append(NA)
            value_lst.append(mapping_view_name)
            value_lst.append(NA)
            value_lst.append(NA)
            value_lst.append(alu_egg.get_id())
            value_lst.append(alu_egg.get_name())
            value_lst.append(alu_egg.get_capacity())
            value_lst.append(NA)
            value_lst.append(NA)
            value_lst.append(alu_egg.get_status())
            value_lst.append(alu_egg.get_wwn())
            value_lst.append(alu_egg.get_type())
    return value_lst


def get_storage_bean_lst(storage_lst):
    """
    获取storage group集合
    :param storage_lst: [[单个storage对应的回文],...]
    :return: storage_bean_lst
    """
    storage_bean_lst = []
    for sg_lst in storage_lst:
        storage_bean = get_storage_bean(sg_lst)
        storage_bean_lst.append(storage_bean)
    return storage_bean_lst


def get_lun_entity(cmd_desc, report_path, lun_id):
    flag = False
    temp_lst = []
    lun_bean = LunEntity()
    lun_bean.set_id(lun_id)
    f_handler = open(report_path, 'r')
    for f_line in f_handler:
        line = f_line.strip()
        if cmd_desc.strip().lower() == line.lower():
            flag = True
            continue
        if flag:
            if divide.strip().lower() in line.lower():
                break
            else:
                temp_lst.append(line)
    f_handler.close()
    if bool(temp_lst):
        update_lun_bean(lun_bean, temp_lst)

    return lun_bean


def update_lun_bean(lun_bean, temp_lst):
    for idx, temp in enumerate(temp_lst):
        if ('uid' in temp.lower()) and (':' in temp.lower()):
            wwn_lst = re.split('\\s+', temp)
            lun_wwn = wwn_lst[-1].strip()
            lun_bean.set_wwn(lun_wwn)
        elif ('capacity' in temp.lower()) and ('megabytes' in temp.lower()):
            cap_lst = re.split('\\s+', temp)
            cap = cap_lst[-1].strip()
            cap = str(round(float(cap) / 1024.0, 2))
            lun_bean.set_capacity(cap + 'GB')
        elif temp and temp.strip().lower().startswith('name'):
            name_lst = re.split('\\s+', temp)
            rep = name_lst[0].strip()
            name = temp.strip()
            name = name.replace(rep, '')
            name = name.strip()
            lun_bean.set_name(name)
        elif ('state' in temp.lower()) and (':' in temp.lower()):
            state_lst = re.split(':', temp)
            state = state_lst[-1]
            state = state.strip()
            lun_bean.set_status(state)
        elif ('meta' in temp.lower()) and (':' in temp.lower() and 'lun' in temp.lower()):
            lun_type_arr = re.split(':', temp)
            if lun_type_arr[-1].lower().strip() == 'yes':
                lun_bean.set_type("meta")
        elif ('thin' in temp.lower()) and (':' in temp.lower() and 'lun' in temp.lower()):
            lun_type_arr = re.split(':', temp)
            if lun_type_arr[-1].lower().strip() == 'yes':
                lun_bean.set_type("thin")


def get_storage_group_lst(cmd_value_lst):
    """
    获取每个storage所对应的列表
    :param cmd_value_lst: 所有storage gp所对应的回文列表
    :return: 单个storage对应的回文
    """
    # 过滤掉无用的数据
    check_lst = []
    for line in cmd_value_lst:
        if '' != line.strip():
            check_lst.append(line)
    cmd_value_lst = check_lst
    storage_index_lst = []
    for i, line in enumerate(cmd_value_lst):
        if ('storage' in line.lower()) and ('group' in line.lower()) \
                and ('name' in line.lower()):
            storage_index_lst.append(i)

    # 每个storage group对应一个lst
    storage_group_lst = []
    sg_idx_lst_len = len(storage_index_lst)
    for j in range(sg_idx_lst_len):
        start = storage_index_lst[j]
        if j < sg_idx_lst_len - 1:
            end = storage_index_lst[j + 1]
        else:
            end = len(cmd_value_lst)
        storage_group_lst.append(cmd_value_lst[start:end])
    return storage_group_lst


def get_storage_bean(storage_lst):
    storage_bean = StorageGroupEntity()
    if storage_lst is None or 0 == len(storage_lst):
        return storage_bean
    for line in storage_lst:
        if ('storage' in line.lower()) and ('group' in line.lower()) and ('name' in line.lower()):
            name = line.split(':')[-1].strip()
            storage_bean.set_name(name)
            continue
        if ('storage' in line.lower()) and ('group' in line.lower()) and ('uid' in line.lower()):
            id_templst = re.split('\\s+', line.strip())
            uid = id_templst[-1].strip()
            storage_bean.set_id(uid)
    # 获取alu num lst
    get_alu_num_lst(storage_bean, storage_lst)
    return storage_bean


def get_alu_num_lst(storage_bean, storage_lst):
    start = 0
    end = 0
    has_alu = False
    for i, line in enumerate(storage_lst):
        if ('alu' in line.lower()) and ('number' in line.lower()):
            start = i + 2
            has_alu = True
            continue
        if 'shareable' in line.lower():
            end = i
            break
    if has_alu:
        alu_lst = storage_lst[start:end]
        alu_num_lst = []
        for alu in alu_lst:
            alu = alu.strip()
            line_lst = re.split('\\s+', alu)
            num = line_lst[-1].strip()
            alu_num_lst.append(num)
        storage_bean.set_alulst(alu_num_lst)


class StorageGroupEntity:
    __group_name = NA
    __group_uid = NA
    __alu_lst = []

    def get_name(self):
        return self.__group_name

    def get_uid(self):
        return self.__group_uid

    def get_alulst(self):
        return self.__alu_lst

    def set_name(self, name):
        self.__group_name = name

    def set_id(self, uid):
        self.__group_uid = uid

    def set_alulst(self, lst):
        self.__alu_lst = lst


class LunEntity:
    __mapping_name = NA
    __gp_id = NA
    __lun_gp_name = NA
    __lun_id = NA
    __lun_name = NA
    __capacity = NA
    __host_id = NA
    __status = NA
    __lun_wwn = NA
    __lun_type = NA

    def set_mapping_name(self, mapping_name):
        self.__mapping_name = mapping_name

    def set_lun_gp_name(self, gp_name):
        self.__lun_gp_name = gp_name

    def set_id(self, lun_id):
        self.__lun_id = lun_id

    def set_name(self, name):
        self.__lun_name = name

    def set_capacity(self, cap):
        self.__capacity = cap

    def set_host_id(self, host_id):
        self.__host_id = host_id

    def set_gp_id(self, gp_id):
        self.__gp_id = gp_id

    def set_status(self, sta):
        self.__status = sta

    def set_wwn(self, wwn):
        self.__lun_wwn = wwn

    def set_type(self, lun_type):
        self.__lun_type = lun_type

    def get_mapping_name(self):
        return self.__mapping_name

    def get_lun_gp_name(self):
        return self.__lun_gp_name

    def get_id(self):
        return self.__lun_id

    def get_name(self):
        return self.__lun_name

    def get_capacity(self):
        return self.__capacity

    def get_host_id(self):
        return self.__host_id

    def get_gp_id(self):
        return self.__gp_id

    def get_status(self):
        return self.__status

    def get_wwn(self):
        return self.__lun_wwn

    def get_type(self):
        return self.__lun_type
