#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# --*-- coding:utf-8 --*--
import sys 
import os
import re
import json

reload(sys) 
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)

from common.contentParse import getValueFMap
from common.contentParse import addValueToMap
from common.contentParse import get_jsonstr
from common.contentParse import get_attrcom_dicv2
from common.contentParse import get_attrvalue_dic
from common.contentParse import get_jsonarr_name
from common.contentParse import style
from storages.EMC.emc_storage_util import EMC_VNX
from storages.EMC.emc_storage_util import NA
from storages.EMC.emc_storage_util import check_vmax_json
from storages.EMC.emc_storage_util import parse_vplex_cli_table_result

# 对应excel中的属性字段
key_lst = [
    'mapping_view_id', 'mapping_view_name'
]


def execute(context):
    """
    获取解析信息：映射名称
    :param context: 上下文
    :return: context
    """
    command = getValueFMap(context, style, 'command').strip()
    attribute_arr = []

    addValueToMap(context, style, 'command', command)
    # 属性名与对应命令列表组成的字典
    attrcom_dic = get_attrcom_dicv2(context)
    # 对应execel属性名
    json_attr_name = get_jsonarr_name(attrcom_dic)
    attr_valuelst_dic = get_attrvalue_dic(context, attrcom_dic)

    # 获取attribute ,value_lst
    for key in key_lst:
        for attr in attr_valuelst_dic.keys():
            if key.lower().strip() in attr.lower():
                attribute_arr.append(attr)

    storage_group_lst = attr_valuelst_dic[attribute_arr[0]]
    dev_model = getValueFMap(context, style, 'dev_model').strip()
    # 根据storage group回文获取storage bean 列表
    storage_bean_lst = get_storage_bean_list(storage_group_lst, dev_model)

    # 根据storage实体列表求value_lst
    if bool(storage_group_lst):
        value_lst = []
        for egg in storage_bean_lst:
            value_lst.append(egg.get_id())
            value_lst.append(egg.get_name())
    else:
        value_lst = [NA, NA]

    # 获取json结果字符串
    result = get_jsonstr(json_attr_name, attribute_arr, value_lst)
    addValueToMap(context, style, 'result', result)
    return context


def get_storage_bean_list(storage_group_list, dev_model):
    """
    根据不同设备类型场景获取映射信息
    :param storage_group_list: 映射回显信息
    :param dev_model: 设备类型
    :return: StorageBean list
    """
    bean_list = []
    if EMC_VNX == dev_model:
        return get_bean_lst(storage_group_list)
    else:
        # 其他场景不采集映射视图名称
        return bean_list


def get_vplex_bean_list(storage_group_list):
    """
    解析Vplex映射信息
    :param storage_group_list: 回显信息
    :return: bean list
    """
    bean_list = []
    headers = ["Name", "initiator-ports", "virtual-volumes"]
    result_list = parse_vplex_cli_table_result(storage_group_list, headers)
    for row in result_list:
        mapping_bean = MappingViewBean()
        mapping_bean.set_name(row[headers[0]])
        bean_list.append(mapping_bean)
    return bean_list


def get_vmax_bean_list(storage_group_list):
    """
    解析VMAX映射信息
    :param storage_group_list: 回显信息
    :return: bean list
    """
    bean_list = []
    if not bool(storage_group_list):
        return bean_list
    for line in storage_group_list:
        if not check_vmax_json(line):
            continue
        masking_view = json.loads(line)["maskingView"][0]
        mapping_bean = MappingViewBean()
        mapping_bean.set_name(masking_view["maskingViewId"])
        bean_list.append(mapping_bean)
    return bean_list


def get_bean_lst(storage_group_lst):
    bean_lst = []
    mapping_bean = MappingViewBean()
    if not bool(storage_group_lst):
        return bean_lst
    for line in storage_group_lst:
        if 'storage' not in line.lower() or 'group' not in line.lower():
            continue
        if 'name' in line.lower():
            mapping_bean = MappingViewBean()
            name = line.split(':')[-1].strip()
            mapping_bean.set_name(name)
        elif 'uid' in line.lower():
            id_templst = re.split('\\s+', line.strip())
            mapping_bean.set_id(id_templst[-1].strip())
            bean_lst.append(mapping_bean)
    return bean_lst


class MappingViewBean:

    __mapping_view_id = 'NA'

    __mapping_view_name = 'NA'

    def get_id(self):
        return self.__mapping_view_id

    def get_name(self):
        return self.__mapping_view_name

    def set_id(self, mapping_id):
        self.__mapping_view_id = mapping_id

    def set_name(self, mapping_name):
        self.__mapping_view_name = mapping_name
