#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from common.cmd_execute import BaseCmdExecute, DES, CMD
from storages.Fujistu.fujistu_san_util import get_lun_group_name_list

CMD_LIST = [
    {DES: "cmd_display_system", CMD: "show enclosure-status"},
    {DES: "cmd_display_mapping_info", CMD: "show host-affinity"},
    {DES: "cmd_display_lun_group_info", CMD: "show affinity-groups"},
    {DES: "cmd_display_lun_detail_info", CMD: "show volumes -mode uid"},
    {DES: "cmd_display_host_info", CMD: "show host-wwn-names"},
]

LUN_GROUP_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_lun_group_detail_", CMD: "show affinity-groups -ag-name %s"},
]


def execute(context):
    FujistuStorageSanInfo(context).execute()


class FujistuStorageSanInfo(BaseCmdExecute):
    def __init__(self, context):
        BaseCmdExecute.__init__(self, context)

    def execute(self):
        """
        类的执行入口
        """
        self.cmd_list = CMD_LIST
        self.generate_relative_cmd_list(self.get_lun_group_name_list(), LUN_GROUP_RELATIVE_CMD_DICTS)
        self.execute_pure_cmd_list()

    def get_lun_group_name_list(self):
        """
        获取虚拟机名列表
        :return: 数据
        """
        cmd = "show affinity-groups"
        data_info = self.cli.execCmd(cmd)
        lun_group_names = get_lun_group_name_list(data_info.splitlines())
        return map(lambda name: (name,), lun_group_names)
