#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from storages.Fujistu.fujistu_san_util import get_mapping_data, check_line, KEY_WORD_NO, KEY_WORD_NAME, is_split_line
from storages.storage_common import get_storage_format_info, get_mapping_view_name, get_command_result_lines, HostInfo
from storages.storage_san_constant import HOST_NAME, MV_ID, HOST_GROUP_NAME, HOST_LIST, HOST_GROUP_ID


def execute(context):
    """
    入口执行方法
    :param context: 上下文数据
    :return: context
    """
    return get_storage_format_info(context, parse_host_info, [HostInfo().get_host_info_dict()], False)


def parse_host_info(context):
    """
    主机解析（映射视图中的）
    :param context: 上下文
    :return: [{}, ...]
    """
    all_host_data = get_all_host_list(context)
    host_mapping, group_mapping = get_mapping_data(context)
    host_list = []
    host_list.extend(parse_host_for_host_mapping(host_mapping, all_host_data))
    host_list.extend(parse_host_for_host_group_mapping(group_mapping, all_host_data))
    return host_list


def get_all_host_list(context):
    """
    主机详细信息解析
    :param context: 上下文
    :return: 主机
    """
    host_info_lines = get_command_result_lines(context, "show host-wwn-names")
    content_flag, host, all_host_data = False, HostInfo(), {}
    for line in host_info_lines:
        if check_line(line, KEY_WORD_NO, KEY_WORD_NAME):
            content_flag = True
            continue
        if not content_flag or is_split_line(line):
            continue
        items = line.split()
        if len(items) == 5:
            host = HostInfo()
            host.set_host_id(items[0])
            host.set_host_name(items[1])
            host.set_initiator_wwn(items[2])
            all_host_data[host.get_host_name()] = host
    return all_host_data


def parse_host_for_host_mapping(host_mapping, all_host_data):
    """
    解析主机维度的视图
    :param host_mapping: 映射视图
    :param all_host_data: 所有主机数据
    :return: 主机数据[{}, ...]
    """
    host_list = []
    for host_data in host_mapping:
        host_name = host_data.get(HOST_NAME, "")
        mv_id = host_data.get(MV_ID, 0)
        if host_name not in all_host_data:
            continue
        host = all_host_data.get(host_name).copy_host()
        host.set_mapping_view_id(mv_id)
        host.set_mapping_view_name(get_mapping_view_name(mv_id))
        host_list.append(host.get_host_info_dict())
    return host_list


def parse_host_for_host_group_mapping(group_mapping, all_host_data):
    """
    解析主机组维度的视图
    :param group_mapping: 映射视图
    :param all_host_data: 所有主机数据
    :return: 主机数据[{}, ...]
    """
    host_list = []
    for host_group_data in group_mapping:
        host_group_id = host_group_data.get(HOST_GROUP_ID, "")
        host_group_name = host_group_data.get(HOST_GROUP_NAME, "")
        host_list_in_mapping = host_group_data.get(HOST_LIST, [])
        mv_id = host_group_data.get(MV_ID, 0)
        if not host_group_name or not host_list_in_mapping:
            continue
        for host_name in host_list_in_mapping:
            if host_name not in all_host_data:
                continue
            host = all_host_data.get(host_name).copy_host()
            host.set_host_group_id(host_group_id)
            host.set_host_group_name(host_group_name)
            host.set_mapping_view_id(mv_id)
            host.set_mapping_view_name(get_mapping_view_name(mv_id))
            host_list.append(host.get_host_info_dict())
    return host_list
