#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from storages.Fujistu.fujistu_san_util import FUJISTU
from storages.NetApp.san.netapp_storage_san_util import get_value_data
from storages.storage_common import NA, get_default_empty_system_info, get_storage_format_info
from storages.storage_common import get_command_result_lines


def execute(context):
    return get_storage_format_info(context, get_report_info, get_default_empty_system_info(), True)


def get_report_info(context):
    """
    获取系统信息
    :param context: 系统信息回显行
    :return: []，与system_info_keys对应
    """
    model, sn, version = get_system_info(context)
    return [NA, NA, FUJISTU, FUJISTU + " S3", FUJISTU + " " + model, version, sn, NA]


def get_system_info(context):
    """
    获取设备信息
    :param context: 上下文
    :return: 设备信息
    """
    model, sn, version = "", "", ""
    cli_result = get_command_result_lines(context, "show enclosure-status")
    model_key_word = "Model Name"
    sn_key_word = "Serial Number"
    version_key_word = "Firmware Version"
    for line in cli_result:
        line = line.strip()
        if not model and line.startswith(model_key_word):
            model = data_format(get_value_data(line, model_key_word))
            continue
        if not sn and line.startswith(sn_key_word):
            sn = data_format(get_value_data(line, sn_key_word))
            continue
        if not version and line.startswith(version_key_word):
            version = data_format(get_value_data(line, version_key_word))
            continue
    return model, sn, version


def data_format(data):
    """
    数据格式化，去除前后的[]符号
    :param data: 数据
    :return: 处理后的数据
    """
    return data.lstrip("[").rstrip("]")
