#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# HDS存储脚本工具类
import sys
import os

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..")
sys.path.append(path)

from storage_common import get_resource

REPORT_PATH = None
LANGUAGE = None
ERR_MSG = 'err_msg'
CMD_DISPLAY = 'cmd_display'


def common_execute(context, info_id, info_desc):
    """
    离线导入获取文件信息
    :param context: 上下文
    :param info_id: 内容ID
    :param info_desc: 内容命令或文件
    :return:
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global LANGUAGE
    LANGUAGE = context.get("lang")
    global REPORT_PATH
    REPORT_PATH = context.get("reportPath")
    cmd_display = context.get("ret_map")
    logger = context.get("Logger")

    if REPORT_PATH:
        offline_read_csv(cmd_display, logger, info_id, info_desc)
    else:
        cmd_display.put(ERR_MSG, get_resource(LANGUAGE, "invalid_file_path"))
    return cmd_display


# 读取HDS CSV文件
def offline_read_csv(cmd_display, logger, file_info_id, file_info_desc):
    fun_err_msg = ""
    try:
        for index in range(len(file_info_desc)):
            result = file_info_desc[index] + "\r\n"
            with open(REPORT_PATH + file_info_desc[index], "r") as f:
                result += f.read()
            fun_err_msg += \
                file_info_desc[index] + get_resource(LANGUAGE, "execute_success")
            cmd_display.put(CMD_DISPLAY + file_info_id[index][9:], result)
    except IOError as ioe:
        logger.error("Read HDS csv file error: {}".format(ioe))
        fun_err_msg += get_resource(LANGUAGE, "read_csv_file_fail")
    cmd_display.put(ERR_MSG, fun_err_msg)


def check_header_line(line, headers):
    """
    检查表头行
    :param line: 行内容
    :param headers:  指定表头信息
    :return:  boolean
    """

    for header in headers:
        if not header.lower() in line.lower():
            return False
    return True


# 通过表格信息表头名称确定信息所在列数
def check_header_index(header_txt, headers, indexes):
    """
    确定指定表头数组中每个表头，在所有表头数组信息中对应的下标位置
    :param header_txt: 所有表头信息
    :param headers: 指定表头数组
    :param indexes: 下标位置
    :return: boolean
    """

    header_lst = header_txt.lower().split(",")
    for index in range(len(header_lst)):
        for j in range(len(headers)):
            if headers[j].lower() == header_lst[index]:
                indexes[j] = index


# 检查数组（集合）信息的下标是否合理
def check_infos_index(infos, indexes):
    """
    检查最大下标
    :param infos: 信息数组（集合）
    :param indexes: 所有使用的下标
    :return: boolean
    """

    max_index = max(indexes)
    return len(infos) > max_index


def get_host_lun_map(host_lun_info):
    """
    获取主机LUN映射关系
    :param host_lun_info: 主机LUN关系信息
    :return: host_lun_map
    """
    host_lun_keys = []
    host_lun_map = {}
    start_flag = False
    indexes = [1, 5]
    headers = ["Host Group", "LDEV#"]
    for line in host_lun_info:
        if not start_flag and check_header_line(line, headers):
            start_flag = True
            check_header_index(line, headers, indexes)
            continue
        if start_flag and bool(line):
            infos = line.split(",")
            if not check_infos_index(infos, indexes):
                continue
            host_name = infos[indexes[0]]
            lun_wwn = infos[indexes[1]]
            host_lun_key = host_name + "_" + lun_wwn
            # 去掉主机名或LUN WWN为空的行，或对应关系已出现的行
            if not bool(host_name) or not bool(lun_wwn) \
                    or host_lun_key in host_lun_keys:
                continue
            host_lun_keys.append(host_lun_key)
            if host_name in host_lun_map:
                host_lun_map[host_name].append(lun_wwn)
            else:
                host_lun_map[host_name] = [lun_wwn]
    return host_lun_map


def get_host_group_map(host_lun_map):
    """
    更新主机组ID
    @:param host_lun_map: 主机LUN映射信息
    @:param host_id_map: 主机名和初始ID信息
    """
    host_group_map = {}
    lun_groups = {}
    group_id = 0
    for host_name in host_lun_map:
        lun_group = host_lun_map[host_name]
        group_wwn = append_list_to_string(lun_group)
        if group_wwn in lun_groups:
            host_group_map[host_name] = lun_groups[group_wwn]
        else:
            group_id += 1
            host_group_map[host_name] = group_id
            lun_groups[group_wwn] = group_id
    return host_group_map


def append_list_to_string(lun_group):
    group_wwn = ""
    for lun_wwn in lun_group:
        group_wwn += "_" + lun_wwn
    return group_wwn
