#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# --*-- coding:utf-8 --*--
import sys
import os

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)

from common.contentParse import getValueFMap
from common.contentParse import addValueToMap
from common.contentParse import get_jsonstr
from common.contentParse import get_attrvalue_dic
from common.contentParse import get_attrcom_dicv2
from common.contentParse import get_jsonarr_name
from common.contentParse import style
from storages.HDS.hds_storage_util import check_header_line
from storages.HDS.hds_storage_util import check_header_index
from storages.HDS.hds_storage_util import check_infos_index
from storages.HDS.hds_storage_util import get_host_lun_map
from storages.HDS.hds_storage_util import get_host_group_map

# 对应excel中的属性字段
key_lst = [
    'mapping_view_id', 'mapping_view_name', 'host_group_id',
    'host_group_name', 'host_id', 'host_name', 'host_type',
    'initiator_wwn', 'port'
]


def execute(context):
    """
    获取HDS存储主机配置信息
    :param context: 上下文
    :return: context
    """
    command = getValueFMap(context, style, 'command').strip()
    attribute_arr = []

    addValueToMap(context, style, 'command', command)
    attr_cmd_dic = get_attrcom_dicv2(context)
    # 对应excel属性名
    json_attr_name = get_jsonarr_name(attr_cmd_dic)
    attr_value_lst_dic = get_attrvalue_dic(context, attr_cmd_dic)

    # 获取attribute ,value_lst
    for key in key_lst:
        for attr in attr_value_lst_dic.keys():
            if key.lower().strip() in attr.lower():
                attribute_arr.append(attr)

    host_info = attr_value_lst_dic[attribute_arr[4]]
    host_lun_info = attr_value_lst_dic[attribute_arr[2]]
    host_value_list = get_host_info(host_info, host_lun_info)

    value_lst = []
    for host_obj in host_value_list:
        if host_obj is None:
            continue
        value_lst.append(str(host_obj.get_mapping_view_id()))
        value_lst.append(host_obj.get_mapping_view_name())
        value_lst.append(str(host_obj.get_host_group_id()))
        value_lst.append(host_obj.get_host_group_name())
        value_lst.append('NA')
        value_lst.append(host_obj.get_host_name())
        value_lst.append('NA')
        value_lst.append(host_obj.get_host_wwn())
        value_lst.append(host_obj.get_port())

    # 获取json结果字符串
    result = get_jsonstr(json_attr_name, attribute_arr, value_lst)
    addValueToMap(context, style, 'result', result)
    return context


def get_host_info(host_info_lst, host_lun_info):
    """
    获取host对象集合
    :param host_info_lst: 主机信息
    :param host_lun_info: 主机lUN映射信息
    :return: 主机集合
    """
    host_lun_map = get_host_lun_map(host_lun_info)
    host_group_map = get_host_group_map(host_lun_map)
    host_list = []
    host_group_id = max(host_group_map.values())
    host_init_keys = []
    start_flag = False
    indexes = [1, 4]
    headers = ["Host Group", "WWN"]
    for line in host_info_lst:
        if not start_flag and check_header_line(line, headers):
            start_flag = True
            check_header_index(line, headers, indexes)
            continue
        if start_flag and line.strip():
            infos = line.split(",")
            if not check_infos_index(infos, indexes):
                continue
            wwn = infos[indexes[1]]
            host_name = infos[indexes[0]]
            host_init_key = host_name + "_" + wwn
            # 若主机启动器WWN号为空，则此行无效，不解析
            if not wwn.strip() or host_init_key in host_init_keys:
                continue
            host_init_keys.append(host_init_key)
            if host_name not in host_group_map:
                host_group_id += 1
                host_group_map[host_name] = host_group_id
            group_id = host_group_map[host_name]
            host_obj = HostEntity()
            host_obj.set_host_group_id(group_id)
            host_obj.set_mapping_view_id(group_id)
            id_str = ('00' + str(group_id))[-3:]
            host_obj.set_host_group_name("HostGroup" + id_str)
            host_obj.set_mapping_view_name("MappingView" + id_str)
            host_obj.set_host_name(host_name)
            host_obj.set_host_wwn(wwn)
            host_list.append(host_obj)
    return host_list


class HostEntity:

    __mapping_view_id = 'NA'
    __mapping_view_name = 'NA'
    __host_group_id = 'NA'
    __host_group_name = 'NA'
    __host_id = 'NA'
    __host_name = 'NA'
    __host_type = 'NA'
    __host_wwn = 'NA'
    __port = 'NA'

    # get
    def get_mapping_view_id(self):
        return self.__mapping_view_id

    def get_mapping_view_name(self):
        return self.__mapping_view_name

    def get_host_group_id(self):
        return self.__host_group_id

    def get_host_group_name(self):
        return self.__host_group_name

    def get_host_id(self):
        return self.__host_id

    def get_host_name(self):
        return self.__host_name

    def get_host_type(self):
        return self.__host_type

    def get_host_wwn(self):
        return self.__host_wwn

    def get_port(self):
        return self.__port

    # set
    def set_mapping_view_id(self, mapping_view_id):
        self.__mapping_view_id = mapping_view_id

    def set_mapping_view_name(self, mapping_view_name):
        self.__mapping_view_name = mapping_view_name

    def set_host_group_id(self, host_group_id):
        self.__host_group_id = host_group_id

    def set_host_group_name(self, host_group_name):
        self.__host_group_name = host_group_name

    def set_host_id(self, host_id):
        self.__host_id = host_id

    def set_host_name(self, host_name):
        self.__host_name = host_name

    def set_host_type(self, host_type):
        self.__host_type = host_type

    def set_host_wwn(self, wwn):
        self.__host_wwn = wwn

    def set_port(self, port):
        self.__port = port
