#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# --*-- coding:utf-8 --*--
import sys
import os

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)

from common.contentParse import getValueFMap
from common.contentParse import addValueToMap
from common.contentParse import get_jsonstr
from common.contentParse import get_attrcom_dicv2
from common.contentParse import get_attrvalue_dic
from common.contentParse import get_jsonarr_name
from common.contentParse import style
from storages.HDS.hds_storage_util import check_header_index
from storages.HDS.hds_storage_util import check_header_line
from storages.HDS.hds_storage_util import check_infos_index
from storages.HDS.hds_storage_util import get_host_lun_map
from storages.HDS.hds_storage_util import get_host_group_map

# 对应excel中的属性字段
key_lst = [
    'mapping_view_id', 'mapping_view_name', 'lun_group_id',
    'lun_group_name', 'lun_id', 'lun_name', 'capacity',
    'host_id', 'hostgroup_id', 'status', 'lun_wwn', 'lun_type'
]


def execute(context):
    """
    获取HDS存储主机和LUN关联信息
    :param context: 上下文
    :return: context
    """
    command = getValueFMap(context, style, 'command').strip()
    attribute_arr = []

    addValueToMap(context, style, 'command', command)
    attr_cmd_dic = get_attrcom_dicv2(context)
    # 对应excel属性名
    json_attr_name = get_jsonarr_name(attr_cmd_dic)
    attr_value_lst_dic = get_attrvalue_dic(context, attr_cmd_dic)

    # 获取attribute ,value_lst
    for key in key_lst:
        for attr in attr_value_lst_dic.keys():
            if key.lower().strip() in attr.lower():
                attribute_arr.append(attr)

    # 获取LUN基本信息
    sys_info_txt = attr_value_lst_dic[attribute_arr[5]]
    sys_sn = get_sys_sn(sys_info_txt)
    lun_info_txt = attr_value_lst_dic[attribute_arr[4]]
    lun_obj_map = get_lun_basic(lun_info_txt, sys_sn)

    # 获取LUN和主机的映射关系信息
    host_lun_txt = attr_value_lst_dic[attribute_arr[8]]
    lun_obj_lst = get_host_lun_lst(host_lun_txt, lun_obj_map)

    value_lst = get_value_lst(lun_obj_lst)
    result = get_jsonstr(json_attr_name, attribute_arr, value_lst)
    addValueToMap(context, style, 'result', result)
    return context


def get_value_lst(lun_obj_lst):
    """
    整合需要返回的信息
    :param lun_obj_lst: 解析的LUN信息集合
    :return: 整合后的信息集合
    """
    value_lst = []
    added_lun_mapping = []
    for lun_obj in lun_obj_lst:
        if lun_obj is None:
            continue
        lun_mapping = lun_obj.get_mapping_view_name() + "_" + lun_obj.get_wwn()
        # 去除重复添加的映射组
        if lun_mapping in added_lun_mapping:
            continue
        added_lun_mapping.append(lun_mapping)
        value_lst.append(str(lun_obj.get_mapping_view_id()))
        value_lst.append(lun_obj.get_mapping_view_name())
        value_lst.append(str(lun_obj.get_group_id()))
        value_lst.append(lun_obj.get_group_name())
        value_lst.append(str(lun_obj.get_id()))
        value_lst.append(lun_obj.get_name())
        value_lst.append(lun_obj.get_capacity())
        value_lst.append('NA')
        value_lst.append(str(lun_obj.get_host_group_id()))
        value_lst.append('NA')
        value_lst.append(lun_obj.get_wwn())
        value_lst.append(lun_obj.get_type())
    return value_lst


def get_sys_sn(sys_info_txt):
    """
    获取设备SN
    :param sys_info_txt: 设备基本信息
    :return: 设备SN
    """
    start_flag = False
    indexes = [1]
    headers = ["Serial Number#"]
    serial_no = "HDS"
    for line in sys_info_txt:
        if not start_flag and check_header_line(line, headers):
            start_flag = True
            check_header_index(line, headers, indexes)
            continue
        if start_flag and line.strip():
            infos = line.split(",")
            if not check_infos_index(infos, indexes):
                continue
            serial_no = infos[indexes[0]]
            break
    return serial_no


def get_lun_basic(lun_info_txt, sys_sn):
    """
    获取LUN基本信息
    :param lun_info_txt: LUN信息
    :param sys_sn: 设备SN
    :return: LUN信息字典
    """
    start_flag = False
    index_lst = [1, 2, 4, 7]
    headers = ["LDEV#", "LDEV Name", "LDEV Type", "Volume Size(MB)"]
    lun_obj_map = {}
    for line in lun_info_txt:
        if not start_flag and check_header_line(line, headers):
            start_flag = True
            check_header_index(line, headers, index_lst)
            continue
        if start_flag and line.strip():
            infos = line.split(",")
            if not check_infos_index(infos, index_lst):
                continue
            lun_obj = LunEntity()
            lun_obj.set_wwn(infos[index_lst[0]])
            lun_name = infos[index_lst[1]]
            lun_name = format_lun_name(lun_name, lun_obj.get_wwn(), sys_sn)
            lun_obj.set_id(int(lun_obj.get_wwn().replace(":", ""), 16))
            lun_obj.set_name(lun_name)
            lun_obj.set_type(infos[index_lst[2]])
            lun_obj.set_capacity(infos[index_lst[3]] + "MB")
            lun_obj_map[lun_obj.get_wwn()] = lun_obj
    return lun_obj_map


def format_lun_name(lun_name, lun_wwn, sys_sn):
    """
    格式化LUN名称
    :param lun_name: LUN名称
    :param lun_wwn: LUN WWN
    :param sys_sn: 设备SN
    :return: 新LUN名称
    """
    wwn_id = "_" + lun_wwn[2:].replace(":", "")
    if not lun_name.strip():
        return "LUN_" + sys_sn + wwn_id
    elif len(lun_name) > 26:
        return lun_name[0:26] + wwn_id
    else:
        return lun_name + wwn_id


def get_host_id_map(host_info_txt):
    """
    解析主机名称和ID的映射关系信息
    :param host_info_txt: 主机信息
    :return: 主机名和ID字典
    """
    start_flag = False
    index_lst = [1, 4]
    headers = ["Host Group", "WWN"]
    host_id_map = {}
    host_group_id = 0
    for line in host_info_txt:
        if not start_flag and check_header_line(line, headers):
            start_flag = True
            check_header_index(line, headers, index_lst)
            continue
        if start_flag and line.strip():
            infos = line.split(",")
            if not check_infos_index(infos, index_lst):
                continue
            wwn = infos[index_lst[1]]
            if not wwn.strip():
                continue
            host_name = infos[index_lst[0]]
            if host_name not in host_id_map:
                host_group_id += 1
                host_id_map[host_name] = host_group_id
    return host_id_map


def update_host_id_map(host_lun_txt, host_id_map):
    """
    获取无启动器的主机
    :param host_lun_txt: 主机LUN映射信息
    :param host_id_map: 主机ID
    """
    start_flag = False
    indexes = [1, 5]
    headers = ["Host Group", "LDEV#"]
    other_id = max(host_id_map.values())
    for line in host_lun_txt:
        if not start_flag and check_header_line(line, headers):
            start_flag = True
            check_header_index(line, headers, indexes)
            continue
        if start_flag and line.strip():
            infos = line.split(",")
            if not check_infos_index(infos, indexes):
                continue
            lun_wwn = infos[indexes[1]].strip()
            host_name = infos[indexes[0]]
            if not host_name.strip() or not lun_wwn:
                continue
            if host_name not in host_id_map:
                other_id += 1
                host_id_map[host_name] = other_id


def get_host_lun_lst(host_lun_txt, lun_obj_map):
    """
    解析获取主机LUN映射关系信息
    :param host_lun_txt: 主机LUN映射信息
    :param lun_obj_map: LUN对象字典
    :return: LUN集合
    """
    host_lun_lst = []
    host_lun_map = get_host_lun_map(host_lun_txt)
    host_group_map = get_host_group_map(host_lun_map)
    for host_name in host_lun_map:
        group_id = host_group_map[host_name]
        lun_group = host_lun_map[host_name]
        for lun_wwn in lun_group:
            lun_obj = lun_obj_map[lun_wwn]
            append_new_lun_obj(lun_obj, group_id, host_lun_lst)
    return host_lun_lst


def append_new_lun_obj(lun_obj, group_id, host_lun_lst):
    """
    在组中增加lun_obj对象
    :param lun_obj: LUN对象
    :param group_id: 组ID
    :param host_lun_lst: 主机LUN映射信息
    """
    if lun_obj is not None and group_id is not None:
        lun_obj = copy_lun_obj(lun_obj)
        lun_obj.set_host_group_id(group_id)
        lun_obj.set_mapping_view_id(group_id)
        lun_obj.set_group_id(group_id)
        id_str = ('00' + str(group_id))[-3:]
        lun_obj.set_mapping_view_name("MappingView" + id_str)
        lun_obj.set_group_name("LunGroup" + id_str)
        host_lun_lst.append(lun_obj)


def copy_lun_obj(source_lun_obj):
    """
    复制lun_obj对象
    :param source_lun_obj: 源lun_obj
    :return: 新lun_obj
    """
    lun_obj = LunEntity()
    lun_obj.set_mapping_view_id(source_lun_obj.get_mapping_view_id())
    lun_obj.set_mapping_view_name(source_lun_obj.get_mapping_view_name())
    lun_obj.set_group_id(source_lun_obj.get_group_id())
    lun_obj.set_group_name(source_lun_obj.get_group_name())
    lun_obj.set_id(source_lun_obj.get_id())
    lun_obj.set_name(source_lun_obj.get_name())
    lun_obj.set_capacity(source_lun_obj.get_capacity())
    lun_obj.set_host_id(source_lun_obj.get_host_id())
    lun_obj.set_host_group_id(source_lun_obj.get_host_group_id())
    lun_obj.set_status(source_lun_obj.get_status())
    lun_obj.set_wwn(source_lun_obj.get_wwn())
    lun_obj.set_type(source_lun_obj.get_type())
    return lun_obj


class LunEntity:

    __mapping_view_id = 'NA'
    __mapping_view_name = 'NA'
    __lun_group_id = 'NA'
    __lun_group_name = 'NA'
    __lun_id = 'NA'
    __lun_name = 'NA'
    __capacity = 'NA'
    __host_id = 'NA'
    __host_group_id = 'NA'
    __status = 'NA'
    __lun_wwn = 'NA'
    __lun_type = 'NA'

    # set
    def set_mapping_view_id(self, mapping_view_id):
        self.__mapping_view_id = mapping_view_id

    def set_mapping_view_name(self, mapping_view_name):
        self.__mapping_view_name = mapping_view_name

    def set_group_id(self, group_id):
        self.__lun_group_id = group_id

    def set_group_name(self, group_name):
        self.__lun_group_name = group_name

    def set_id(self, id):
        self.__lun_id = id

    def set_name(self, name):
        self.__lun_name = name

    def set_capacity(self, cap):
        self.__capacity = cap

    def set_host_id(self, host_id):
        self.__host_id = host_id

    def set_host_group_id(self, host_group_id):
        self.__host_group_id = host_group_id

    def set_status(self, sta):
        self.__status = sta

    def set_wwn(self, wwn):
        self.__lun_wwn = wwn

    def set_type(self, type):
        self.__lun_type = type

    # get
    def get_mapping_view_id(self):
        return self.__mapping_view_id

    def get_mapping_view_name(self):
        return self.__mapping_view_name

    def get_group_id(self):
        return self.__lun_group_id

    def get_group_name(self):
        return self.__lun_group_name

    def get_id(self):
        return self.__lun_id

    def get_name(self):
        return self.__lun_name

    def get_capacity(self):
        return self.__capacity

    def get_host_id(self):
        return self.__host_id

    def get_host_group_id(self):
        return self.__host_group_id

    def get_status(self):
        return self.__status

    def get_wwn(self):
        return self.__lun_wwn

    def get_type(self):
        return self.__lun_type
