#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# HDS存储基本信息
import sys
import os

reload(sys)
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)

from common.contentParse import getValueFMap
from common.contentParse import addValueToMap
from common.contentParse import get_jsonstr
from common.contentParse import get_attrvalue_dic
from common.contentParse import get_attrcom_dic
from common.contentParse import get_jsonarr_name
from common.contentParse import style
from storages.HDS.hds_storage_util import check_header_line
from storages.HDS.hds_storage_util import check_header_index
from storages.HDS.hds_storage_util import check_infos_index

# 对应excel中的属性字段
key_lst = ['report_date/time', 'infograb_version', 'storage_vendor', 'storage_series',
           'storage_model', 'storage_firmware', 'storage_serial', 'ip_address']


# 获取HDS存储基本信息
def execute(context):
    # 获取回文
    command = getValueFMap(context, style, 'command').strip()
    attribute_arr = []

    addValueToMap(context, style, 'command', command)
    attr_cmd_dic = get_attrcom_dic(context)
    # 对应excel属性名
    json_attr_name = get_jsonarr_name(attr_cmd_dic)

    attr_value_lst_dic = get_attrvalue_dic(context, attr_cmd_dic)
    # 获取attribute_arr
    for key in key_lst:
        for attr in attr_value_lst_dic.keys():
            if key.lower().strip() in attr.lower():
                attribute_arr.append(attr)

    # storage_model
    model_lst = attr_value_lst_dic[attribute_arr[4]]
    storage_model, serial_no = get_sys_info(model_lst)

    firmware_lst = attr_value_lst_dic[attribute_arr[5]]
    storage_firmware = get_firmware(firmware_lst)

    value_lst = ['NA', 'NA', 'HDS', get_storage_series(storage_model),
                 storage_model, storage_firmware, serial_no, 'NA']
    # 获取json结果字符串
    result = get_jsonstr(json_attr_name, attribute_arr, value_lst)
    addValueToMap(context, style, 'result', result)
    return context


def get_storage_series(storage_model):
    """
    获取设备系列信息
    :param storage_model: 设备型号
    :return: 系列
    """
    upper_model = storage_model.upper()
    if "VSP G" in upper_model:
        return "VSP G Series"
    if "VSP F" in upper_model:
        return "VSP F Series"
    if "VSP" in upper_model:
        return "VSP"
    if "HUS VM" in upper_model:
        return "HUS VM"
    if "HUS" in upper_model:
        return "HUS Series"
    if "HDS NSC55" in upper_model:
        return "HDS NSC55"
    if "USP" in upper_model:
        return "USP Series"
    if "AMS" in upper_model:
        return "AMS Series"
    return 'NA'


# storage_model, storage_serial_no
def get_sys_info(dkc_info_lst):
    start_flag = False
    indexes = [0, 1]
    headers = ["Storage System Type", "Serial Number#"]
    storage_model = "NA"
    serial_no = "NA"
    for line in dkc_info_lst:
        if not start_flag and check_header_line(line, headers):
            start_flag = True
            check_header_index(line, headers, indexes)
            continue
        if start_flag and line.strip():
            data_lst = line.split(",")
            if not check_infos_index(data_lst, indexes):
                continue
            storage_model = data_lst[indexes[0]]
            serial_no = data_lst[indexes[1]]
            break
    return storage_model, serial_no


# storage_firmware
def get_firmware(line_lst):
    start_flag = False
    indexes = [0]
    headers = ["DKCMAIN"]
    storage_firmware = "NA"
    for line in line_lst:
        if check_header_line(line, headers):
            start_flag = True
            check_header_index(line, headers, indexes)
            continue
        if start_flag and line.strip():
            infos = line.split(",")
            if not check_infos_index(infos, indexes):
                continue
            storage_firmware = str(infos[indexes[0]])
            break
    return storage_firmware
