# --*-- coding:utf-8 --*--
import re
from common.contentParse import getValueFMap, style, addValueToMap, get_jsonarr_name, get_jsonstr, \
    get_purecommands_lst, get_comdslst_byfile, get_attrlst_dic, is_success
from storages.storage_common import remove_bad_end_content_for_hp, deduplicate

global key_lst  #对应Excel中属性列表
global attribute_arr #从传入的命令中获取的属性列表 
global  value_lst
global context

#对应excel中的属性字段
key_lst  = [
                'mapping_view_id','mapping_view_name','host_group_id','host_group_name','host_id','host_name','host_type','initiator_wwn','port'
            ]

#获取Linux主机集群 Server信息
def execute(context):
    #获取回文
    #start
    path = getValueFMap(context,style,'path')
    command = getValueFMap(context,style,'command').strip()
    attribute_arr = []
    value_lst = []
    
    addValueToMap(context,style,'command',command)
    attrcom_dic = get_attrcom_dicv2(context)
    #对应execel属性名
    json_attr_name = get_jsonarr_name(attrcom_dic)
   
    attr_valuelst_dic = get_attrvalue_dic(context,attrcom_dic)
    #获取attribute ,value_lst
    for key in key_lst:
        for attr in attr_valuelst_dic.keys():
            if key.lower().strip() in attr.lower():
                attribute_arr.append(attr)
    
    hostid = attr_valuelst_dic.get('host_id')
    hostgroup = attr_valuelst_dic.get('host_group_id')
    hostType = attr_valuelst_dic.get('host_type')
    if is_success(hostid) and is_success(hostgroup):
        hostvalue_list = get_hostset_info(hostid,hostgroup,hostType)
    
        hostobj = hostset_Entity()
        hostvalue_list = deduplicate(hostvalue_list)
        for hostobj in hostvalue_list:
            value_lst.append('NA')
            value_lst.append('NA')
            value_lst.append(hostobj.get_hostgroupid())
            value_lst.append(hostobj.get_hostgroupname())
            value_lst.append(hostobj.get_hostid())
            value_lst.append(hostobj.get_hostname())
            value_lst.append(hostobj.get_hosttype())
            value_lst.append(hostobj.get_hostwwn())
            value_lst.append(hostobj.get_port())
    else :
        value_lst = ['NA', 'NA', 'NA', 'NA', 'NA', 'NA', 'NA', 'NA','NA']
    
    #获取json结果字符串                
    result = get_jsonstr(json_attr_name,attribute_arr, value_lst)
    addValueToMap(context,style,'result',result)
    return context



#获取storage group 对象集合
def get_hostset_info(txt_hostid,txt_hostgroup,hostType):
    
    hosttxt_list = txt_hostid[3:-1]
    hosttxt_list = remove_bad_end_content_for_hp(hosttxt_list)
    host_list = get_host_list(hosttxt_list)
    host_set_list = get_host_set_list(txt_hostgroup)
    all_host_list = get_all_host_and_full_host_list(host_set_list, host_list)
    host_type_list = hostdesc(hostType)
    set_host_type(host_list, host_type_list)
    all_host_list.extend(host_list)
    return all_host_list


def set_host_type(host_list, host_type_list):
    """
    设置主机的类型
    :param host_list: 主机列表
    :param host_type_list: 主机类型列表
    """
    for host_obj in host_list:
        for host_type_obj in host_type_list:
            if host_obj.get_hostid() == host_type_obj.get_hostType_Id().strip():
                host_obj.set_hosttype(host_type_obj.get_hostType_Name())
                break


def get_all_host_and_full_host_list(host_set_list, host_list):
    """
    获取主机信息、主机组中的主机添加到主机列表
    :param host_set_list: 主机组列表
    :param host_list: 主机列表
    :return: 主机信息
    """
    all_host_list = []
    host_in_set = []
    for host_set_obj in host_set_list:
        if host_set_obj.get_hostname() == 'NA':
            all_host_list.append(host_set_obj)
            continue
        for host_obj in host_list:
            if host_set_obj.get_hostname() == host_obj.get_hostname():
                new_host_obj = copy_host_object(host_obj)
                new_host_obj.set_hostgroupid(host_set_obj.get_hostgroupid())
                new_host_obj.set_hostgroupname(host_set_obj.get_hostgroupname())
                new_host_obj.set_hostid("NA")
                host_in_set.append(new_host_obj)
    host_list.extend(host_in_set)
    return all_host_list


def get_host_set_list(txt_host_group):
    """
    解析主机组列表
    :param txt_host_group: 主机组信息回文
    :return: 主机组列表
    """
    hostsettxt_list = txt_host_group[3:-1]
    hostsettxt_list = remove_bad_end_content_for_hp(hostsettxt_list)
    hostsetname = 'NA'
    hostsetid = 'NA'
    hostsetlist = []
    for line in hostsettxt_list:
        settemp_arr = re.split('\\s+', line)
        hostsetobj = hostset_Entity()
        if len(settemp_arr) == 3:
            hostsetobj.set_hostgroupid(settemp_arr[0])
            hostsetobj.set_hostgroupname(settemp_arr[1])
            if settemp_arr[2] != '--':
                hostsetobj.set_hostname(settemp_arr[2])
            hostsetid = settemp_arr[0]
            hostsetname = settemp_arr[1]
            hostsetlist.append(hostsetobj)
        else:
            hostsetobj.set_hostgroupid(hostsetid)
            hostsetobj.set_hostgroupname(hostsetname)
            hostsetobj.set_hostname(settemp_arr[0])
            hostsetlist.append(hostsetobj)
    return hostsetlist


def get_host_list(hosttxt_list):
    """
    解析主机列表
    :param hosttxt_list: 主机信息回文
    :return: 主机列表
    """
    host_list = []
    for line in hosttxt_list:
        host_obj = hostset_Entity()
        set_temp_arr = re.split('\\s+', line)
        if set_temp_arr[1] == '--':
            continue
        host_obj.set_hostid(set_temp_arr[0])
        host_obj.set_hostname(set_temp_arr[1])
        host_obj.set_hostwwn(set_temp_arr[3])
        if '--' not in set_temp_arr[4]:
            host_obj.set_port(set_temp_arr[4])
        host_list.append(host_obj)
    return host_list


def copy_host_object(host_obj):
    """
    复制Host对象属性到新的对象
    :param host_obj: 原始Host象数据
    :return: 新Host对象数据
    """
    new_host_obj = hostset_Entity()
    new_host_obj.set_hostgroupid(host_obj.get_hostgroupid())
    new_host_obj.set_hostgroupname(host_obj.get_hostgroupname())
    new_host_obj.set_hostid(host_obj.get_hostid())
    new_host_obj.set_hostname(host_obj.get_hostname())
    new_host_obj.set_hosttype(host_obj.get_hosttype())
    new_host_obj.set_hostwwn(host_obj.get_hostwwn())
    new_host_obj.set_port(host_obj.get_port())
    return new_host_obj


def get_attrvalue_dic(context,attrcom_dic):
    all_comds_lst = get_purecommands_lst(attrcom_dic)
    path = getValueFMap(context,style,'path')
    all_comds_byfile = get_comdslst_byfile(all_comds_lst,path)
    return get_attrlst_dic(attrcom_dic,all_comds_byfile,path)

def hostdesc(hostTypeTxt):
    hostType = hostTypeTxt[2:-1]
    hostType = remove_bad_end_content_for_hp(hostType)
    hostTypeList = []
    if len(hostType) >= 10:
        for line in hostType:
            temparr = re.split(':', line)
            if len(temparr) == 2 and 'id' in temparr[0].lower():
                hostTypeObj = hostType_Entity()
                hostTypeObj.set_hostType_Id(temparr[1])
            if len(temparr) == 2 and 'os' in temparr[0].lower():
                hostTypeObj.set_hostType_Name(temparr[1].strip())
                hostTypeList.append(hostTypeObj);
    else:
        hostTypeObj = hostType_Entity()
        hostTypeList.append(hostTypeObj)
        
    return hostTypeList
                


def get_attrcom_dicv2(context):
    command = getValueFMap(context,style,'command')
    #去除最后面的';'
    if ';' == command.strip()[-1]:
        command = command[0:-1]
    attrcom_dic= {}
    try:
        for comd in command.split(';'):
            if comd.count(':')==1:
                lst = comd.split(':')
                key = lst[0].strip()
                if (1 < len(lst))and (',' in lst[1]):
                    addValueToMap(attrcom_dic, style, key, lst[1].strip().split(','))
                else:
                    addValueToMap(attrcom_dic, style, key, [lst[1].strip()])
            else:
                value_lst = comd.split(':')
                key = value_lst[0].strip()
                rep = key+':'
                value = comd.replace(rep,'')
                value = value.strip()
                addValueToMap(attrcom_dic, style, key,[value])
    except:
        raise Exception("Not Leagal ,this commands..")
    return attrcom_dic

class hostType_Entity:
    __hostType_Id = 'NA'
    __hostType_Name = 'NA'
    
    def get_hostType_Id(self):
        return self.__hostType_Id
    def get_hostType_Name(self):
        return self.__hostType_Name
    def set_hostType_Id(self,id):
        self.__hostType_Id = id
    def set_hostType_Name(self,name):
        self.__hostType_Name = name


class hostset_Entity:
    __hostgroup_id = 'NA'
    __hostgroup_name = 'NA'
    __hostid = 'NA'
    __hostname = 'NA'
    __hosttype = 'NA'
    __hostwwn = 'NA'
    __port = 'NA'

    def to_str(self):
        return "hostgroup_id:" + self.__hostgroup_id, \
               "hostgroup_name:" + self.__hostgroup_name, \
               "hostid:" + self.__hostid, \
               "hostname:" + self.__hostname, \
               "hosttype:" + self.__hosttype, \
               "hostwwn:" + self.__hostwwn, \
               "port:" + self.__port
    
    def get_hostgroupid(self):
        return self.__hostgroup_id
    def get_hostgroupname(self):
        return self.__hostgroup_name
    def get_hostid(self):
        return self.__hostid
    def get_hostname(self):
        return self.__hostname
    def get_hosttype(self):
        return self.__hosttype
    def get_hostwwn(self):
        return self.__hostwwn
    def get_port(self):
        return self.__port

    #set 
    def set_hostgroupid(self,hostgroupid):
        self.__hostgroup_id = hostgroupid
    def set_hostgroupname(self,hostgroupname):
        self.__hostgroup_name = hostgroupname
    def set_hostid(self,hostid):
        self.__hostid = hostid
    def set_hostname(self,hostname):
        self.__hostname = hostname
    def set_hosttype(self,hosttype):
        self.__hosttype = hosttype
    def set_hostwwn(self,wwn):
        self.__hostwwn = wwn
    def set_port(self,port):
        self.__port = port
