# --*-- coding:utf-8 --*--
import re
from common.contentParse import getValueFMap, style, addValueToMap, get_jsonarr_name, get_jsonstr, \
    get_purecommands_lst, get_comdslst_byfile, get_attrlst_dic
from storages.storage_common import remove_bad_end_content_for_hp, deduplicate

global key_lst  #对应Excel中属性列表
global attribute_arr #从传入的命令中获取的属性列表 
global value_lst
global context

NA = 'NA'

#对应excel中的属性字段
key_lst  = [
                'mapping_view_id','mapping_view_name','lun_group_id','lun_group_name','lun_id','lun_name','capacity','host_id','hostgroup_id','status','lun_wwn','lun_type'           
            ]

#获取Linux主机集群 Server信息
def execute(context):
    #获取回文
    #start
    path = getValueFMap(context,style,'path')
    command = getValueFMap(context,style,'command').strip()
    attribute_arr = []
    value_lst = []
    
    addValueToMap(context,style,'command',command)
    attrcom_dic = get_attrcom_dicv2(context)
    #对应execel属性名
    json_attr_name = get_jsonarr_name(attrcom_dic)
    attr_valuelst_dic = get_attrvalue_dic(context,attrcom_dic)
    #获取attribute ,value_lst
    #获取json结果字符串          
    
    lunobj_list = get_vvdetail_set(attr_valuelst_dic)      
    lunobj_list = get_lun_set_info(lunobj_list, attr_valuelst_dic)
    lunobj_list = get_vlun_info(lunobj_list,attr_valuelst_dic)
    
    for key in key_lst:
        for attr in attr_valuelst_dic.keys():
            if key.lower().strip() in attr.lower():
                attribute_arr.append(attr)
    
    lunobj = Lun_Entity()
    lunobj_list = deduplicate(lunobj_list)
    for lunobj in lunobj_list:
        value_lst.append('NA')
        value_lst.append('NA')
        value_lst.append(lunobj.get_groupid())
        value_lst.append(lunobj.get_groupname())
        value_lst.append(lunobj.get_id())
        value_lst.append(lunobj.get_name())
        value_lst.append(lunobj.get_capacity())
        value_lst.append(lunobj.get_hostid())
        value_lst.append(lunobj.get_hostgroupid())
        value_lst.append(lunobj.get_status())
        value_lst.append(lunobj.get_wwn())
        value_lst.append(lunobj.get_type())
    
    result = get_jsonstr(json_attr_name,attribute_arr, value_lst)
    addValueToMap(context,style,'result',result)
    return context



def get_vvdetail_set(txt):
    vvdetail_list = txt.get(key_lst[4])[3:-1]
    vvdetail_list = remove_bad_end_content_for_hp(vvdetail_list)
    lun_obj_list = []
    for line in vvdetail_list:
        lunobj = Lun_Entity()
        vvdetail_temp = re.split('\\s+', line)
        if len(vvdetail_temp) == 6 :
            lunobj.set_id(vvdetail_temp[0])
            lunobj.set_name(vvdetail_temp[1])
            lunobj.set_status(vvdetail_temp[2])
            cap = str(round(float(vvdetail_temp[3])/1024.0,2))+'GB'
            lunobj.set_capacity(cap)
            lunobj.set_wwn(vvdetail_temp[4])
            lunobj.set_type(vvdetail_temp[5])
            lun_obj_list.append(lunobj)
            
    return lun_obj_list


def parse_lun_set(line, lun_set_id, lun_set_name):
    """
    解析LUN组信息
    :param line: Lun组数据行
    :param lun_set_id: LUN组ID
    :param lun_set_name: LUN组名字
    :return: LUN组信息
    """
    lun_set_info = re.split('\\s+', line)
    if len(lun_set_info) == 3:
        return lun_set_info[0], lun_set_info[1], lun_set_info[2]
    return lun_set_id, lun_set_name, lun_set_info[0]


def get_lun_set_info(lun_obj_list, txt):
    """
    解析LUN组里面的LUN数据
    :param lun_obj_list: 已解析的LUN信息
    :param txt: LUN组回显信息
    :return: 所有LUN信息
    """
    vv_list = txt.get(key_lst[3])[3:-1]
    vv_list = remove_bad_end_content_for_hp(vv_list)
    lun_set_id, lun_set_name = NA, NA
    for line in vv_list:
        lun_set_id, lun_set_name, lun_name = parse_lun_set(line, lun_set_id, lun_set_name)
        for lun_obj in lun_obj_list:
            if lun_obj.get_name() != lun_name:
                continue
            if lun_obj.get_groupname() == NA:
                lun_obj.set_groupid(lun_set_id)
                lun_obj.set_groupname(lun_set_name)
                break
            new_lun_obj = copy_lun_object(lun_obj)
            new_lun_obj.set_groupid(lun_set_id)
            new_lun_obj.set_groupname(lun_set_name)
            lun_obj_list.append(new_lun_obj)
            break
    return lun_obj_list


def get_host_list(templates_list):
    """
    获取主机 列表
    :param templates_list: 回文
    :return: 主机 列表
    """
    hostobj_list = []
    for line in templates_list:
        hostobj = Host_Entity()
        temparr = re.split('\\s+', line)
        if 'set:' in temparr[1]:
            lunset = temparr[1].split(':')
            hostobj.set_vvset(lunset[1])
        else:
            hostobj.set_vvname(temparr[1])
        if 'set:' in temparr[3]:
            hostset = temparr[3].split(':')
            hostobj.set_hostset(hostset[1])
            hostobj_list.append(hostobj)
        else:
            hostobj.set_hostname(temparr[3])
            hostobj_list.append(hostobj)
    return hostobj_list


def setup_host_id_by_group_content(hostset_list, hostobj):
    """
    封装主机信息
    :param hostset_list: 主机组回文
    :param hostobj: 主机
    """
    for line in hostset_list:
        temparr = re.split('\\s+', line)
        if len(temparr) > 1 and hostobj.get_hostset() == temparr[1]:
            hostobj.set_hostid(temparr[0])
            break


def setup_host_id_by_host_content(host_list, hostobj):
    """
    封装 主机信息（非主机组）
    :param host_list: 主机回文
    :param hostobj: 主机
    """
    for line in host_list:
        hosttemparr = re.split('\\s+', line)
        if hostobj.get_hostname() == hosttemparr[1]:
            hostobj.set_hostid(hosttemparr[0])
            break


def setup_host_id(hostobj_list, hostset_list, host_list):
    """
    封装 主机信息
    :param hostobj_list: 主机 列表
    :param hostset_list: 主机组回文
    :param host_list: 主机回文
    """
    for hostobj in hostobj_list:
        if hostobj.get_hostname() == 'NA':
            setup_host_id_by_group_content(hostset_list, hostobj)
        else:
            setup_host_id_by_host_content(host_list, hostobj)


def get_vlun_info(lunobj_list,txt):
    vlun_list = txt.get(key_lst[2])[3:-1]
    line_flag = 0
    for i,line in enumerate(vlun_list):
        if 'vlun' in line.lower() and 'templates' in line.lower():
            line_flag = i
            break
    templates_list = vlun_list[line_flag+2:-2]
    hostobj_list = get_host_list(remove_bad_end_content_for_hp(templates_list))
    hostset_list = txt.get('status')[3:-1]
    host_list = txt.get('host_id')[3:-1]
    setup_host_id(hostobj_list, remove_bad_end_content_for_hp(hostset_list), remove_bad_end_content_for_hp(host_list))

    return parse_lun_map(lunobj_list, hostobj_list)


def parse_lun_map(lun_obj_list, host_obj_list):
    """
    解析LUN映射信息，以主机对象集合为遍历基准，复制LUN对象并补充主机信息
    :param lun_obj_list: LUN对象集合
    :param host_obj_list: 主机对象集合
    :return: 包含映射信息的LUN对象集合
    """
    map_lun_obj_list = []
    for host_obj in host_obj_list:
        if host_obj.get_vvset() != NA:
            map_lun_obj_list.extend(parse_lun_map_from_group(lun_obj_list, host_obj))
            continue
        for lun_obj in lun_obj_list:
            if lun_obj.get_name() == host_obj.get_vvname():
                new_lun_obj = get_map_lun(lun_obj, host_obj)
                # 单个LUN映射不配置LUN组名称和LUN组ID
                new_lun_obj.set_groupname(NA)
                new_lun_obj.set_groupid(NA)
                map_lun_obj_list.append(new_lun_obj)
                break
    return map_lun_obj_list


def parse_lun_map_from_group(lun_obj_list, host_obj):
    """
    解析主机映射的LUN组中的LUN信息
    :param lun_obj_list: LUN信息集合
    :param host_obj: 主机映射信息
    :return: LUN组中的LUN映射信息
    """
    map_lun_obj_list = []
    for lun_obj in lun_obj_list:
        if lun_obj.get_groupname() != NA and lun_obj.get_groupname() == host_obj.get_vvset():
            map_lun_obj_list.append(get_map_lun(lun_obj, host_obj))
    return map_lun_obj_list


def get_map_lun(lun_obj, host_obj):
    """
    获取映射LUN，为LUN设置关联的主机(组)id
    :param lun_obj: LUN信息
    :param host_obj: 关联的主机(组)信息
    :return: 映射LUN信息
    """
    map_lun = copy_lun_object(lun_obj)
    if host_obj.get_hostname() == NA:
        map_lun.set_hostgroupid(host_obj.get_hostid())
    else:
        map_lun.set_hostid(host_obj.get_hostid())
    return map_lun


def copy_lun_object(lun_obj):
    """
    复制LUN对象属性到新的对象，用于LUN共享映射
    :param lun_obj: 原始LUN对象数据
    :return: 新LUN对象数据
    """
    new_lun_obj = Lun_Entity()
    new_lun_obj.set_capacity(lun_obj.get_capacity())
    new_lun_obj.set_status(lun_obj.get_status())
    new_lun_obj.set_wwn(lun_obj.get_wwn())
    new_lun_obj.set_name(lun_obj.get_name())
    new_lun_obj.set_id(lun_obj.get_id())
    new_lun_obj.set_type(lun_obj.get_type())
    new_lun_obj.set_hostid(lun_obj.get_hostid())
    new_lun_obj.set_hostgroupid(lun_obj.get_hostgroupid())
    new_lun_obj.set_groupid(lun_obj.get_groupid())
    new_lun_obj.set_groupname(lun_obj.get_groupname())
    return new_lun_obj


def get_attrvalue_dic(context,attrcom_dic):
    all_comds_lst = get_purecommands_lst(attrcom_dic)
    path = getValueFMap(context,style,'path')
    all_comds_byfile = get_comdslst_byfile(all_comds_lst,path)
    return get_attrlst_dic(attrcom_dic,all_comds_byfile,path)


def get_attrcom_dicv2(context):
    command = getValueFMap(context,style,'command')
    #去除最后面的';'
    if ';' == command.strip()[-1]:
        command = command[0:-1]
    attrcom_dic= {}
    try:
        for comd in command.split(';'):
            if comd.count(':')==1:
                lst = comd.split(':')
                key = lst[0].strip()
                if (1 < len(lst))and (',' in lst[1]):
                    addValueToMap(attrcom_dic, style, key, lst[1].strip().split(','))
                else:
                    addValueToMap(attrcom_dic, style, key, [lst[1].strip()])
            else:
                value_lst = comd.split(':')
                key = value_lst[0].strip()
                rep = key+':'
                value = comd.replace(rep,'')
                value = value.strip()
                addValueToMap(attrcom_dic, style, key,[value])
    except:
        raise Exception("Not Leagal ,this commands..")
    return attrcom_dic

class Host_Entity:
    __hostname = 'NA'
    __hostset = 'NA'
    __vvname = 'NA'
    __vvset = 'NA'
    __hostid = 'NA'
    #get 
    def get_hostname(self):
        return self.__hostname
    def get_hostset(self):
        return self.__hostset
    def get_vvname(self):
        return self.__vvname
    def get_vvset(self):
        return self.__vvset
    def get_hostid(self):
        return self.__hostid
    
    #set 
    def set_hostname(self,name):
        self.__hostname = name
    def set_hostset(self,hostset):
        self.__hostset = hostset
    def set_vvname(self,vvname):
        self.__vvname = vvname
    def set_vvset(self,vvset):
        self.__vvset = vvset
    def set_hostid(self,hostid):
        self.__hostid = hostid

        
class Lun_Entity:
    __lungroup_id = 'NA'
    __lungroup_name = 'NA'
    __lun_id = 'NA'
    __lun_name = 'NA'
    __capacity = 'NA'
    __host_id = 'NA'
    __host_groupid = 'NA'
    __status = 'NA'
    __lun_wwn = 'NA'
    __lun_type = 'NA'

    def to_str(self):
        return "lungroup_id:" + self.__lungroup_id, \
               "lungroup_name:" + self.__lungroup_name, \
               "lun_id:" + self.__lun_id, \
               "lun_name:" + self.__lun_name, \
               "capacity:" + self.__capacity, \
               "host_id:" + self.__host_id, \
               "host_groupid:" + self.__host_groupid, \
               "status:" + self.__status, \
               "lun_wwn:" + self.__lun_wwn, \
               "lun_type:" + self.__lun_type

    #set
    def set_groupid(self,groupid):
        self.__lungroup_id = groupid
    def set_groupname(self,groupname):
        self.__lungroup_name = groupname
    def set_id(self,id):
        self.__lun_id = id
    def set_name(self,name):
        self.__lun_name = name
    def set_capacity(self,cap):
        self.__capacity = cap
    def set_hostid(self,hostid):
        self.__host_id = hostid
    def set_hostgroupid(self,hostgroupid):
        self.__host_groupid = hostgroupid
    def set_status(self,sta):
        self.__status = sta
    def set_wwn(self,wwn):
        self.__lun_wwn = wwn
    def set_type(self,type):
        self.__lun_type = type
        
    #get
    def get_groupid(self):
        return self.__lungroup_id
    def get_groupname(self):
        return self.__lungroup_name
    def get_id(self):
        return self.__lun_id 
    def get_name(self):
        return self.__lun_name  
    def get_capacity(self):
        return self.__capacity
    def get_hostid(self):
        return self.__host_id
    def get_hostgroupid(self):
        return self.__host_groupid
    def get_status(self):
        return self.__status
    def get_wwn(self):
        return self.__lun_wwn
    def get_type(self):
        return self.__lun_type
    
