# --*-- coding:utf-8 --*--
import sys 
import os
import re
from cmd import Cmd
reload(sys) 
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import *

# 对应excel中的属性字段
key_lst = ['report_date/time', 'infograb_version', 'storage_vendor', 'storage_series',
           'storage_model', 'storage_firmware', 'storage_serial', 'ip_address']


#获取Linux主机集群 Server信息
def execute(context):
    #获取回文
    #start
    path = getValueFMap(context,style,'path')
    command = getValueFMap(context,style,'command').strip()
    attribute_arr = []
    
    addValueToMap(context,style,'command',command)
    attrcom_dic = get_attrcom_dic(context)
    #对应execel属性名
    json_attr_name = get_jsonarr_name(attrcom_dic)
   
    attr_valuelst_dic = get_attrvalue_dic(context,attrcom_dic)
    #获取attribute_arr
    for key in key_lst:
        for attr in attr_valuelst_dic.keys():
            if key.lower().strip() in attr.lower():
                attribute_arr.append(attr)
    
    # storage_model
    model_lst = attr_valuelst_dic[attribute_arr[4]]
    storage_model = get_model(model_lst)

    # storage_firmware
    firmware_lst = attr_valuelst_dic[attribute_arr[5]]
    firmware = get_firmware(firmware_lst)
    
    # storage_serial
    serial_lst = attr_valuelst_dic[attribute_arr[6]]
    storage_serial = get_serial(serial_lst)
    
    value_lst = ['NA', 'NA', 'HP', get_storage_series(storage_model), storage_model, firmware, storage_serial, 'NA']
    # 获取json结果字符串
    result = get_jsonstr(json_attr_name, attribute_arr, value_lst)
    addValueToMap(context, style, 'result', result)
    return context


def get_storage_series(storage_model):
    """
    获取存储设备系列
    :param storage_model: 存储型号
    :return: 系列
    """
    upper_model = storage_model.upper()
    if "3PAR F" in upper_model:
        return "HP3PAR F Series"
    if "3PAR T" in upper_model:
        return "HP3PAR T Series"
    if "3PAR" in upper_model:
        return "HP3PAR StoreServ Series"
    if "EVA" in upper_model:
        return "EVA Series"
    if "MSA" in upper_model:
        return "MSA Series"
    if "XP" in upper_model:
        return "XP Series"
    if "SVS" in upper_model:
        return "SVS_Series"
    if "P" in upper_model:
        return "P Series"
    return "NA"


#storage_model
def get_model(linelst):
    result = "NA"
    for line in linelst:
        if ('model' in line.lower()) and (':' in line.lower()):
            lst = re.split(':',line)
            result = lst[1].strip()
            break
    return result

#storage_firmware
def get_firmware(linelst):
    result = "NA"
    for line in linelst:
        lst = re.split(':',line.strip())
        if lst[0].lower().strip().startswith('os version'):
            result = lst[1].strip()
            break
    return result

#storage_serial
def get_serial(linelst):
    result = "NA"
    for line in linelst:
        if ('serial' in line.lower()) and (':' in line.lower()):
            lst = re.split(':',line)
            result = lst[1].strip()
            break
    return result


def get_attrvalue_dic(context,attrcom_dic):
    all_comds_lst = get_purecommands_lst(attrcom_dic)
    path = getValueFMap(context,style,'path')
    all_comds_byfile = get_comdslst_byfile(all_comds_lst,path)
    return get_attrlst_dic(attrcom_dic,all_comds_byfile,path)


