# coding=utf-8
from cbb.frame.cli import cliUtil
from com.huawei.ism.tool.obase.exception import ToolException

from com.huawei.ism.tool.deploy.entity.\
        AbstractDeployInfoCollectCallableResult import CMD_EXCUTE_ERROR


def execute(context):
    """
    开局兼容性信息收集存储入口
    :param context: 传入上下文
    """
    storage_info = DeployStorageInfo(context)
    storage_info.get_info()


class DeployStorageInfo(object):
    def __init__(self, context):
        self.cli = context.get("cli")
        self.logger = context.get("logger")
        self.lang = context.get("lang")
        self.storage_info = context.get("result")
        self.ui_observer = context.get("uiObserver")
        self.deploy_dev = context.get("deployDev")
        self.cli_ret_list = self.storage_info.getCmdRetList()

    def get_info(self):
        self.cli_ret_list.add(
            "Sn:{}".format(self.deploy_dev.getDeviceSerialNumber()))
        self.set_dev_base_info()
        self.ui_observer.updateDeviceProgress(self.deploy_dev, 30)
        self.set_dev_interface_model()
        self.ui_observer.updateDeviceProgress(self.deploy_dev, 80)

    def set_dev_base_info(self):
        """
        设置基本信息
        """
        try:
            (
                flag,
                product_model,
                version,
                cli_ret,
            ) = cliUtil.getProductModelAndVersion(self.cli, self.lang)
            self.cli_ret_list.add(cli_ret)
            if flag is not True:
                self.storage_info.setStorageSystem(CMD_EXCUTE_ERROR)
                self.storage_info.setStorageSystemVersion(CMD_EXCUTE_ERROR)
            self.storage_info.setStorageSystem(product_model)
            self.storage_info.setStorageSystemVersion(version)
        except (ToolException, Exception) as e:
            self.logger.error("set System exception:{}".format(e))
            self.storage_info.setStorageSystem(CMD_EXCUTE_ERROR)
            self.storage_info.setStorageSystemVersion(CMD_EXCUTE_ERROR)

    def set_dev_interface_model(self):
        """
        设置接口卡信息
        :return:
        """
        model_list = list()
        try:
            cmd = "show interface_module"
            flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(
                self.cli, cmd, True, self.lang
            )
            self.cli_ret_list.add(cli_ret)
            if flag is not True:
                model_list.append(CMD_EXCUTE_ERROR)
                self.storage_info.setArrayInterfaceCards(model_list)
                return

            if cliUtil.queryResultWithNoRecord(cli_ret):
                return

            info_dict_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
            for info_dict in info_dict_list:
                model = info_dict.get("Model", "")
                # 过滤前端接口卡
                if "FE" in model:
                    model_list.append(model)
            self.storage_info.setArrayInterfaceCards(list(set(model_list)))
        except (ToolException, Exception) as e:
            self.logger.error("set System exception:{}".format(e))
            model_list.append(CMD_EXCUTE_ERROR)
            self.storage_info.setArrayInterfaceCards(list(set(model_list)))
