#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import traceback
from storages.HUAWEI.huawei_storage_util import execute_command
from storages.HUAWEI.huawei_storage_util import do_execute_error
from storages.HUAWEI.huawei_storage_util import get_device_class

sys_info_id = "cmd_info_huawei_sys_info"
tv1_sys_info_cmd = "showsys"
common_sys_info_cmd = "show system general"


def execute(context):
    """
    入口执行方法
    :param context: 上下文
    :return: 设备系统信息
    """
    try:
        dev_class = get_device_class(context)
        if dev_class == "TV1":
            execute_command(context, sys_info_id, tv1_sys_info_cmd)
        else:
            execute_command(context, sys_info_id, common_sys_info_cmd)
        return context.get("ret_map")
    except Exception:
        return do_execute_error(context, str(traceback.format_exc()))
