#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.n9000.grab.huawei_9000_domain_info import Huawei9000DomainInfo
from storages.HUAWEI.nas.v3v5.grab.v3v5_domain_info import HuaweiV3V5DomainInfo
from storages.storage_common import STORAGE_DEV_MODEL, STORAGE_HUAWEI_V3_V5, STORAGE_HUAWEI_9000


def execute(context):
    """
    执行华为存储Nas域认证信息采集
    :param context: 上下文
    """
    if context.get(STORAGE_DEV_MODEL, "") == STORAGE_HUAWEI_V3_V5:
        HuaweiV3V5DomainInfo(context).execute()
    if context.get(STORAGE_DEV_MODEL, "") == STORAGE_HUAWEI_9000:
        Huawei9000DomainInfo(context).execute()
