#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.n9000.grab.huawei_9000_ndmp_info import Huawei9000NDMPInfo
from storages.HUAWEI.nas.v3v5.grab.huawei_ndmp_service_info import HuaweiV3V5NdmpServiceInfo
from storages.storage_common import STORAGE_DEV_MODEL, STORAGE_HUAWEI_9000, STORAGE_HUAWEI_V3_V5


def execute(context):
    """
    执行华为存储Nas NDMP设置信息采集
    :param context: 上下文
    :return: 执行结果
    """
    if context.get(STORAGE_DEV_MODEL, "") == STORAGE_HUAWEI_V3_V5:
        HuaweiV3V5NdmpServiceInfo(context).execute()
    if context.get(STORAGE_DEV_MODEL, "") == STORAGE_HUAWEI_9000:
        Huawei9000NDMPInfo(context).execute()
