#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.n9000.grab.huawei_9000_user_mapping_info import Huawei9000UserMappingInfo
from storages.HUAWEI.nas.v3v5.grab.v3v5_user_mapping_info import HuaweiV3V5UserMappingInfo
from storages.storage_common import STORAGE_DEV_MODEL, STORAGE_HUAWEI_9000
from storages.storage_common import STORAGE_HUAWEI_V3_V5


def execute(context):
    """
    执行华为存储Nas用户映射信息采集
    :param context: 上下文
    """
    if context.get(STORAGE_DEV_MODEL, "") == STORAGE_HUAWEI_V3_V5:
        HuaweiV3V5UserMappingInfo(context).execute()
    if context.get(STORAGE_DEV_MODEL, "") == STORAGE_HUAWEI_9000:
        Huawei9000UserMappingInfo(context).execute()
