#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.n9000.grab.huawei_9000_worm_info import Huawei9000WormInfo
from storages.HUAWEI.nas.v3v5.grab.v3v5_worm_info import HuaweiV3V5WormInfo
from storages.storage_common import STORAGE_DEV_MODEL, STORAGE_HUAWEI_V3_V5, STORAGE_HUAWEI_9000


def execute(context):
    """
    执行华为存储Nas概览采集
    :param context: 上下文
    """
    if context.get(STORAGE_DEV_MODEL, "") == STORAGE_HUAWEI_V3_V5:
        HuaweiV3V5WormInfo(context).execute()
    if context.get(STORAGE_DEV_MODEL, "") == STORAGE_HUAWEI_9000:
        Huawei9000WormInfo(context).execute()
