#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD, BaseCmdExecute

ADMIN_CMD_LIST = [
    {DES: "cmd_display_cifs_status", CMD: "show cifs status"},
    {DES: "cmd_display_directory_share_cifs_all_info", CMD: "show directory_share cifs all"},
    {DES: "cmd_display_directory_share_cifs_auth_client_all_info", CMD: "show directory_share cifs_auth_client all"},
    {DES: "cmd_display_nas_service_cifs_service_info", CMD: "show nas_service cifs_service"},
    {DES: "cmd_display_homedir_info", CMD: "show homedir"},
]

ROOT_CMD_LIST = [
    {DES: "cmd_display_smb1_enable_info", CMD: "./nas.sh nas_proto_cfg -c get_smb1_enable"},
]


class Huawei9000CifsShareInfo(BaseCmdExecute):
    def __init__(self, context):
        super(Huawei9000CifsShareInfo, self).__init__(context)
        self.cmd_list = ADMIN_CMD_LIST

    def execute(self):
        """
        1. 执行ADMIN_CMD_LIST中的命令获取基本信息
        2. 通过exit命令退回到root用户
        3. 执行nas.sh脚本收集SMB 1.0 协议的开启状态
        """
        self.execute_pure_cmd_list(self, commands=ADMIN_CMD_LIST, cur_step=5, progress_width=75)
        self.exec_cmd("exit")
        self.change_dir_to_user_home()
        self.execute_pure_cmd_list(self, commands=ROOT_CMD_LIST, cur_step=80, progress_width=15)
