#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD, BaseCmdExecute
from storages.HUAWEI.nas.util.parse_common import parse_table_type_cmd_result

ADMIN_CMD_LIST = [
    {DES: "cmd_display_local_group_all_info", CMD: "show local group all"},
]


def get_group_sid_commands_by_group_id(group_dic_list):
    sid_commands_by_id = []
    for group_dic in group_dic_list:
        group_id = group_dic.get("ID")
        cmd = {
            DES: "cmd_display_group_sid_with_group_id_%s" % group_id,
            CMD: "./nas.sh nas_proto_auth -c lookup-localuser-sid -u %s -t 1" % group_id
        }
        sid_commands_by_id.append(cmd)
    return sid_commands_by_id


def get_group_sid_commands_by_group_name(group_dic_list):
    sid_commands_by_name = []
    for group_dic in group_dic_list:
        group_name = group_dic.get("Name")
        cmd = {
            DES: "cmd_display_group_sid_with_group_name_%s" % group_name,
            CMD: "./nas.sh nas_proto_auth -c lookup-user -n %s -v 0" % group_name
        }
        sid_commands_by_name.append(cmd)
    return sid_commands_by_name


class Huawei9000GroupInfo(BaseCmdExecute):
    def __init__(self, context):
        super(Huawei9000GroupInfo, self).__init__(context)
        self.cmd_list = ADMIN_CMD_LIST

    def execute(self):
        """
        1. 执行ADMIN_CMD_LIST中的命令获取基本信息
        2. 获取每个组sid查询命令的集合，查询每个组的sid信息
        """
        self.execute_pure_cmd_list(self, commands=ADMIN_CMD_LIST, cur_step=5, progress_width=20)
        group_table_lines = self.display.get("cmd_display_local_group_all_info")
        group_dic_list = parse_table_type_cmd_result(group_table_lines.splitlines())
        sid_commands_by_id = get_group_sid_commands_by_group_id(group_dic_list)
        sid_commands_by_name = get_group_sid_commands_by_group_name(group_dic_list)
        self.exec_cmd("exit")
        self.change_dir_to_user_home()
        self.execute_pure_cmd_list(self, commands=sid_commands_by_id, cur_step=25, progress_width=35)
        self.execute_pure_cmd_list(self, commands=sid_commands_by_name, cur_step=60, progress_width=35)
