#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD, BaseCmdExecute

ADMIN_CMD_LIST = [
    {DES: "cmd_display_nfs_status", CMD: "show nfs status"},
    {DES: "cmd_display_directory_share_nfs_all_info", CMD: "show directory_share nfs all"},
    {DES: "cmd_display_directory_share_nfs_auth_client_all_info", CMD: "show directory_share nfs_auth_client all"},
]

ROOT_CMD_LIST = [
    {DES: "cmd_display_nfs_domain_name", CMD: "cat /etc/idmapd.conf"},
    {DES: "cmd_display_nfs_v4_switch_info", CMD: "./nas_nfsv4_ctrl.sh status"},
]


class Huawei9000NfsShareInfo(BaseCmdExecute):
    def __init__(self, context):
        super(Huawei9000NfsShareInfo, self).__init__(context)
        self.cmd_list = ADMIN_CMD_LIST

    def execute(self):
        """
        1. 执行ADMIN_CMD_LIST中的命令获取基本信息
        2. 通过exit命令退回到root用户，cat /etc/idmapd.conf收集NFS v4 的domain name
        3. 执行/usr/local/bin下的nas_nfsv4_ctrl.sh脚本收集NFS v4 的开启状态
        """
        self.execute_pure_cmd_list(self, commands=ADMIN_CMD_LIST, cur_step=5, progress_width=50)
        self.exec_cmd("exit")
        self.exec_cmd("cd /usr/local/bin")
        self.execute_pure_cmd_list(self, commands=ROOT_CMD_LIST, cur_step=55, progress_width=40)
