#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD, BaseCmdExecute

ADMIN_CMD_LIST = [
    {DES: "cmd_display_system_general_info", CMD: "show system general"},
    {DES: "cmd_display_node_capacity_info", CMD: "show node capacity"},
    {DES: "cmd_display_node_general_info", CMD: "show node general"},
    {DES: "cmd_display_file_accesstime_info", CMD: "show file accesstime"},
    {DES: "cmd_display_http_service_info", CMD: "show http service"},
]

ROOT_CMD_LIST = [
    {DES: "cmd_display_anonymous_enable_info", CMD: "./nas.sh nas_proto_cfg -c get_anonymous_enable"},
    {DES: "cmd_display_guest_enable_info", CMD: "./nas.sh nas_proto_cfg -c get_guest_enable"},
]


class Huawei9000OverViewInfo(BaseCmdExecute):
    def __init__(self, context):
        super(Huawei9000OverViewInfo, self).__init__(context)
        self.cmd_list = ADMIN_CMD_LIST

    def execute(self):
        """
        1. 执行ADMIN_CMD_LIST中的命令获取基本信息
        2. 通过exit命令退回到root用户，生成nas.sh脚本供后面用户和组查询sid使用
        3. 通过nas.sh脚本收集匿名和Guest认证状态
        """
        self.execute_pure_cmd_list(self, commands=ADMIN_CMD_LIST, cur_step=5, progress_width=70)
        self.exec_cmd("exit")
        self.change_dir_to_user_home()
        self.touch_nas_sh()
        self.execute_pure_cmd_list(self, commands=ROOT_CMD_LIST, cur_step=75, progress_width=20)

    def touch_nas_sh(self):
        self.exec_cmd("touch nas.sh && chmod +x nas.sh && echo -e '#!/bin/bash\n$*'> nas.sh")
