#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD, BaseCmdExecute
from storages.HUAWEI.huawei_storage_util import parse_key_value_type_result
from storages.HUAWEI.nas.util.parse_common import parse_table_type_cmd_result, grouping_list_by_predicate

ADMIN_CMD_LIST = [
    {DES: "cmd_display_remote_replication_channel_info", CMD: "show remote_replication channel"},
    {DES: "cmd_display_remote_replication_general_info", CMD: "show remote_replication general"},
    {DES: "cmd_display_remote_replication_zone_info", CMD: "show remote_replication zone"},
]


class Huawei9000RemoteReplicationInfo(BaseCmdExecute):
    def __init__(self, context):
        super(Huawei9000RemoteReplicationInfo, self).__init__(context)
        self.cmd_list = ADMIN_CMD_LIST

    def execute(self):
        self.execute_pure_cmd_list(self, commands=ADMIN_CMD_LIST, cur_step=5, progress_width=20)
        self.execute_pure_cmd_list(self, commands=self.get_channel_cmds(), cur_step=25, progress_width=25)
        self.execute_pure_cmd_list(self, commands=self.get_pair_cmds(), cur_step=50, progress_width=25)
        self.execute_pure_cmd_list(self, commands=self.get_zone_cmds(), cur_step=75, progress_width=20)
        self.exec_cmd("exit")

    def get_channel_cmds(self):
        """
        获取通过channel_id查询详情的命令列表
        @return: 命令列表
        """
        channel_info_lines = self.display.get("cmd_display_remote_replication_channel_info")
        channel_dic_list = parse_table_type_cmd_result(channel_info_lines.splitlines())
        channel_cmds = []
        for channel_dic in channel_dic_list:
            channel_id = channel_dic.get("ID")
            cmd1 = {
                DES: "cmd_display_remote_replication_channel_with_channel_id_%s" % channel_id,
                CMD: "show remote_replication channel id=%s" % channel_id
            }
            cmd2 = {
                DES: "cmd_display_remote_replication_link_info_with_channel_id_%s" % channel_id,
                CMD: "show remote_replication link_info %s" % channel_id
            }
            channel_cmds.append(cmd1)
            channel_cmds.append(cmd2)
        return channel_cmds

    def get_pair_cmds(self):
        """
        获取通过pair_id查询详情的命令列表
        @return: 命令列表
        """
        pair_info_lines = self.display.get("cmd_display_remote_replication_general_info")
        pair_dic_list = parse_table_type_cmd_result(pair_info_lines.splitlines())
        pair_cmds = []
        for pair_dic in pair_dic_list:
            pair_id = pair_dic.get("ID")
            cmd1 = {
                DES: "cmd_display_remote_replication_general_info_with_pair_id_%s" % pair_id,
                CMD: "show remote_replication general id=%s" % pair_id
            }
            cmd2 = {
                DES: "cmd_display_remote_replication_latest_snap_path_with_pair_id_%s" % pair_id,
                CMD: "show remote_replication latest_snap_path %s" % pair_id
            }
            pair_cmds.append(cmd1)
            pair_cmds.append(cmd2)
        return pair_cmds

    def get_zone_cmds(self):
        """
        获取通过zone_id查询详情的命令列表
        @return: 命令列表
        """
        zone_info_lines = self.display.get("cmd_display_remote_replication_zone_info")
        zone_group = grouping_list_by_predicate(zone_info_lines.splitlines(),
                                                lambda line: line.strip().startswith("----"))
        replication_cmds = []
        for zone_lines in zone_group:
            zone_dic = parse_key_value_type_result(zone_lines, ":")
            zone_id = zone_dic.get("ID")
            cmd = {
                DES: "cmd_display_remote_replication_zone_working_ip_with_zone_id_%s" % zone_id,
                CMD: "show remote_replication zone_working_ip %s" % zone_id
            }
            replication_cmds.append(cmd)
        return replication_cmds
