#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD, BaseCmdExecute
from storages.HUAWEI.huawei_storage_util import parse_key_value_type_result
from storages.HUAWEI.nas.util.parse_common import grouping_list_by_predicate

ADMIN_CMD_LIST = [
    {DES: "cmd_display_snapshot_general_info", CMD: "show snapshot general"},
    {DES: "cmd_display_snapshot_schedule_info", CMD: "show snapshot_schedule"},
]


class Huawei9000SnapshotInfo(BaseCmdExecute):
    def __init__(self, context):
        super(Huawei9000SnapshotInfo, self).__init__(context)
        self.cmd_list = ADMIN_CMD_LIST

    def execute(self):
        """
        1. 执行ADMIN_CMD_LIST中的命令获取基本信息
        2. 获取每个快照信息查询命令的集合，查询每个快照详细信息
        """
        self.execute_pure_cmd_list(self, commands=ADMIN_CMD_LIST, cur_step=5, progress_width=20)
        snapshot_table_str = self.display.get("cmd_display_snapshot_general_info")
        snapshot_group = grouping_list_by_predicate(snapshot_table_str.splitlines(),
                                                    lambda line: line.strip().startswith("----"))
        info_cmds = []
        for snapshot_lines in snapshot_group:
            snapshot_dic = parse_key_value_type_result(snapshot_lines, ":")
            snapshot_id = snapshot_dic.get("ID")
            cmd = {
                DES: "cmd_display_snapshot_info_with_snapshot_id_%s" % snapshot_id,
                CMD: "show snapshot info %s" % snapshot_id
            }
            info_cmds.append(cmd)
        self.execute_pure_cmd_list(self, commands=info_cmds, cur_step=25, progress_width=70)
        self.exec_cmd("exit")
        self.rm_nas_sh()

    def rm_nas_sh(self):
        """
        nas.sh在nasStorageGrabFlow.xml中的第一个流程采集时生成，在nasStorageGrabFlow.xml最后一个流程采集后删除
        """
        self.change_dir_to_user_home()
        self.exec_cmd("rm -f nas.sh")
