#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD, BaseCmdExecute
from storages.HUAWEI.nas.util.parse_common import parse_table_type_cmd_result

ADMIN_CMD_LIST = [
    {DES: "cmd_display_local_user_all_info", CMD: "show local user all"},
    {DES: "cmd_display_local_user_safe_strategy_info", CMD: "show local user safe_strategy"},
]


def get_user_sid_commands_by_user_id(user_dic_list):
    sid_commands_by_id = []
    for user_dic in user_dic_list:
        user_id = user_dic.get("ID")
        cmd = {
            DES: "cmd_display_user_sid_with_user_id_%s" % user_id,
            CMD: "./nas.sh nas_proto_auth -c lookup-localuser-sid -u %s -t 0" % user_id
        }
        sid_commands_by_id.append(cmd)
    return sid_commands_by_id


def get_user_sid_commands_by_user_name(user_dic_list):
    sid_commands_by_name = []
    for user_dic in user_dic_list:
        user_name = user_dic.get("Name")
        cmd = {
            DES: "cmd_display_user_sid_with_user_name_%s" % user_name,
            CMD: "./nas.sh nas_proto_auth -c lookup-user -n %s -v 0" % user_name
        }
        sid_commands_by_name.append(cmd)
    return sid_commands_by_name


class Huawei9000UserInfo(BaseCmdExecute):
    def __init__(self, context):
        super(Huawei9000UserInfo, self).__init__(context)
        self.cmd_list = ADMIN_CMD_LIST

    def execute(self):
        """
        1. 执行ADMIN_CMD_LIST中的命令获取基本信息
        2. 获取每个用户sid查询命令的集合，查询每个用户的sid信息
        """
        self.execute_pure_cmd_list(self, commands=ADMIN_CMD_LIST, cur_step=5, progress_width=20)
        user_table_str = self.display.get("cmd_display_local_user_all_info")
        user_dic_list = parse_table_type_cmd_result(user_table_str.splitlines())
        sid_commands_by_id = get_user_sid_commands_by_user_id(user_dic_list)
        sid_commands_by_name = get_user_sid_commands_by_user_name(user_dic_list)
        self.exec_cmd("exit")
        self.change_dir_to_user_home()
        self.execute_pure_cmd_list(self, commands=sid_commands_by_id, cur_step=25, progress_width=35)
        self.execute_pure_cmd_list(self, commands=sid_commands_by_name, cur_step=60, progress_width=35)
