#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, parse_table_type_cmd_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 CIFS Server信息
    :param context: 上下文数据
    """
    data_header = ["SecurityModel", "GuestEnable", "SignRequired", "SignEnable", "EnableOpLock", "OpLockTimeout",
                   "NotifyEnable", "UseTcpOnly", "WindowsIP", "AuthenticationDomain", "JoinDomainAnonymously",
                   "AbseEnbale", "SMB2EnabledForDCConnections", "MaxSessionDisplay", "MaxOpenFilesDisplay",
                   "ReserveUnixSecurity", "NTAclEanbled", "SMB3EnabledForDCConnections",
                   "SMB1PriorityEnabledForDCConnections", "Rc4Enabled"]
    parse_data(context, [data_header], get_cifs_server_content)


def get_cifs_server_content(context):
    cifs_server_lines = get_command_result_lines(context, "cmd_display_nas_service_cifs_service_info")
    cifs_server_dict_list = parse_table_type_cmd_result(cifs_server_lines)
    return [
        [cifs_server.get("SecurityModel"), cifs_server.get("GuestEnable"), cifs_server.get("SignRequired"),
         cifs_server.get("SignEnable"), cifs_server.get("EnableOpLock"), cifs_server.get("OpLockTimeout"),
         cifs_server.get("NotifyEnable"), cifs_server.get("UseTcpOnly"), cifs_server.get("WindowsIP"),
         cifs_server.get("AuthenticationDomain"), cifs_server.get("JoinDomainAnonymously"),
         cifs_server.get("AbseEnable"), cifs_server.get("SMB2EnabledForDCConnections"),
         cifs_server.get("MaxSessionDisplay"), cifs_server.get("MaxOpenFilesDisplay"),
         cifs_server.get("ReserveUnixSecurity"), cifs_server.get("NTAclEnabled"),
         cifs_server.get("SMB3EnabledForDCConnections"), cifs_server.get("SMB1PriorityEnabledForDCConnections"),
         cifs_server.get("Rc4Enabled")]
        for cifs_server in cifs_server_dict_list]
