#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import copy

from storages.HUAWEI.nas.util.parse_common import parse_data, parse_table_type_cmd_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 CIFS共享信息
    :param context: 上下文数据
    """
    data_header = ["ID", "Name", "Share Path", "Description", "Enable OpLock", "Enable Notify", "Enable failover",
                   "offlineFileMode", "Enable Abe", "ApplyDefaultAcl", "Dir Mode", "File Mode", "ACL User",
                   "Domain Type", "ACL Permissions"]
    parse_data(context, [data_header], get_cifs_share_content)


def get_cifs_share_content(context):
    data_content = []
    cifs_share_auth_lines = get_command_result_lines(context, "cmd_display_directory_share_cifs_auth_client_all_info")
    cifs_share_auth_dict_list = parse_table_type_cmd_result(cifs_share_auth_lines)
    mapping = build_cifs_client_all_share_path_mapping(cifs_share_auth_dict_list)
    cifs_share_lines = get_command_result_lines(context, "cmd_display_directory_share_cifs_all_info")
    cifs_share_dict_list = parse_table_type_cmd_result(cifs_share_lines)
    build_cifs_data_content(cifs_share_dict_list, mapping, data_content)
    return data_content


def build_cifs_data_content(cifs_share_dict_list, mapping, data_content):
    for cifs_share in cifs_share_dict_list:
        cifs_share_content = build_cifs_share_content(cifs_share)
        name = cifs_share.get("Name")
        if mapping.get(name):
            for data in mapping.get(name):
                new_cifs_share_content = copy.deepcopy(cifs_share_content)
                new_cifs_share_content.extend(data)
                data_content.append(new_cifs_share_content)
        else:
            cifs_share_content.extend([" ", " ", " ", " ", " "])
            data_content.append(cifs_share_content)


def build_cifs_share_content(cifs_share):
    # 部分版本使用Share Path，部分版本使用SharePath
    share_path = cifs_share.get("Share Path") if "Share Path" in cifs_share else cifs_share.get("SharePath")
    return [cifs_share.get("ID"), cifs_share.get("Name"), share_path, cifs_share.get("Description"),
            cifs_share.get("Enable OpLock"), cifs_share.get("Enable Notify"), cifs_share.get("Enable failover"),
            cifs_share.get("offlineFileMode"), cifs_share.get("Enable Abe"), cifs_share.get("ApplyDefaultAcl"),
            cifs_share.get("Dir Mode"), cifs_share.get("File Mode")]


def build_cifs_client_all_share_path_mapping(cifs_share_auth_dict_list):
    cifs_share_auth_dict = {}
    for data in cifs_share_auth_dict_list:
        name = data.get("Share Name")
        cifs_auth_client = cifs_share_auth_dict.get(name, [])
        cifs_auth_client.append([data.get("Name"), data.get("Domain Type"), data.get("Permission")])
        cifs_share_auth_dict[name] = cifs_auth_client
    return cifs_share_auth_dict
