#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_table_type_cmd_result, parse_data, get_key_value_type_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 domains信息
    :param context: 上下文数据
    """
    parent_title = [
        "DNS", "DNS", "AD Domain", "AD Domain", "AD Domain", "AD Domain", "AD Domain", "AD Domain",
        "LDAP Domain", "LDAP Domain", "LDAP Domain", "LDAP Domain", "LDAP Domain", "LDAP Domain", "LDAP Domain",
        "LDAP Domain", "LDAP Domain", "LDAP Domain", "LDAP Domain", "LDAP Domain", "LDAP Domain", "LDAP Domain",
        "LDAP Domain", "LDAP Domain", "NIS Domain", "NIS Domain",
    ]
    sub_title = [
        "address", "targetType", "DomainStatus", "fullDomainName", "OU", "SystemName", "SiteName",
        "JoinDomainErrorCode", "serverIP", "port", "transferType", "bindDN", "userSearchPath",
        "groupSearchPath", "baseDN", "bindLevel", "bindUsingADCred", "netgroup DN", "userSearchScope",
        "groupSearchScope", "netgroupSearchScope", "timelimit", "bindTimelimit", "idleTimelimit",
        "nisDomain", "nisServerAddress"
    ]
    data_header = [parent_title, sub_title]
    parse_data(context, data_header, get_domains_content)


def get_domains_content(context):
    res = []
    dns_lines = get_command_result_lines(context, "cmd_display_external_dns_info")
    dns_lines_dict_list = parse_table_type_cmd_result(dns_lines)
    get_dns_info(dns_lines_dict_list, res)
    get_ad_info(context, res)
    get_ldap_info(context, res)
    get_nis_info(context, res)
    return [res]


def get_dns_info(dns_lines_dict_list, res):
    if dns_lines_dict_list:
        dns = dns_lines_dict_list[0]
        res.extend([dns.get("address"), dns.get("targetType")])
    else:
        res.extend(["", ""])


def get_ad_info(context, res):
    ad_dict = get_key_value_type_result(context, "cmd_display_domain_ad_info", ":")
    res.extend(
        [ad_dict.get("DomainStatus"), ad_dict.get("fullDomainName"), ad_dict.get("OU"), ad_dict.get("SystemName"),
         ad_dict.get("SiteName"), ad_dict.get("JoinDomainErrorCode")])


def get_ldap_info(context, res):
    ldap_dict = get_key_value_type_result(context, "cmd_display_domain_ldap_info", ":")
    res.extend(
        [ldap_dict.get("serverIP"), ldap_dict.get("port"), ldap_dict.get("transferType"), ldap_dict.get("bindDN"),
         ldap_dict.get("userSearchPath"), ldap_dict.get("groupSearchPath"), ldap_dict.get("baseDN"),
         ldap_dict.get("bindLevel"), ldap_dict.get("bindUsingADCred"), ldap_dict.get("netgroup DN"),
         ldap_dict.get("userSearchScope"), ldap_dict.get("groupSearchScope"), ldap_dict.get("netgroupSearchScope"),
         ldap_dict.get("timelimit"), ldap_dict.get("bindTimelimit"), ldap_dict.get("idleTimelimit")])


def get_nis_info(context, res):
    nis_dict = get_key_value_type_result(context, "cmd_display_domain_nis_info", ":")
    res.extend([nis_dict.get("nisDomain"), nis_dict.get("nisServerAddress")])
