#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 通用配置信息
    :param context: 上下文数据
    """
    data_header = [
        "longname_switch", "qos_switch", "qos_disk_type", "qos_bandwidth_basic_hdd", "qos_bandwidth_ratio_hdd",
        "qos_bandwidth_max_hdd", "qos_bandwidth_basic_ssd", "qos_bandwidth_ratio_ssd", "qos_bandwidth_max_ssd"
    ]
    parse_data(context, [data_header], get_general_config_content)


def get_general_config_content(context):
    res = []
    get_longname_content(context, res)
    get_qos_info(context, res)
    return [res]


def get_longname_content(context, res):
    longname_lines = get_command_result_lines(context, "cmd_display_longname_switch_info")
    long_name_dict = get_key_value_type_dict(longname_lines, ":")
    res.extend([long_name_dict.get("longname switch")])


def get_qos_info(context, res):
    qos_lines = get_command_result_lines(context, "cmd_display_qos_config_info")
    qos_dict = get_key_value_type_dict(qos_lines, "=")
    res.extend(
        [qos_dict.get("qos_switch"), qos_dict.get("qos_disk_type"), qos_dict.get("qos_bandwidth_basic_hdd"),
         qos_dict.get("qos_bandwidth_ratio_hdd"), qos_dict.get("qos_bandwidth_max_hdd"),
         qos_dict.get("qos_bandwidth_basic_ssd"), qos_dict.get("qos_bandwidth_ratio_ssd"),
         qos_dict.get("qos_bandwidth_max_ssd")])


def get_key_value_type_dict(cmd_result_lines, separator):
    data_dict = {}
    for line in cmd_result_lines[1:]:
        if not line:
            continue
        if separator not in line:
            continue
        key_value = line.split(separator)
        if len(key_value) == 2:
            key = key_value[0].strip()
            if key:
                data_dict[key] = key_value[1].strip()
    return data_dict
