#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, parse_table_type_cmd_result, get_sid_from_lines
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 本地用户组信息
    :param context: 上下文数据
    """
    data_header = ["Group ID", "Group Name", "Description", "SID Prefix", "SID Suffix", "Type"]
    parse_data(context, [data_header], get_group_content)


def get_group_content(context):
    group_lines = get_command_result_lines(context, "cmd_display_local_group_all_info")
    group_dict_list = parse_table_type_cmd_result(group_lines)
    return [
        [group.get("ID"), group.get("Name"), group.get("Description"), get_group_sid(context, group)[0],
         get_group_sid(context, group)[1], "ALL"]
        for group in group_dict_list]


def get_group_sid(context, group):
    group_lines = get_command_result_lines(context, "cmd_display_group_sid_with_group_id_%s" % group.get("ID"))
    if "<sid>" not in group_lines:
        group_lines = get_command_result_lines(context, "cmd_display_group_sid_with_group_name_%s" % group.get("Name"))
    return get_sid_from_lines(group_lines)
