#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, parse_table_type_cmd_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 Homedir信息
    :param context: 上下文数据
    """
    data_header = ["sharePath", "isOpen"]
    parse_data(context, [data_header], get_home_dir_content)


def get_home_dir_content(context):
    home_dir_lines = get_command_result_lines(context, "cmd_display_homedir_info")
    home_dir_dict_list = parse_table_type_cmd_result(home_dir_lines)
    return [[home_dir.get("sharePath"), home_dir.get("isOpen")] for home_dir in home_dir_dict_list]
