#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_table_type_cmd_result, parse_data
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 infoEqualizer信息
    :param context: 上下文数据
    """
    data_header = ["Name", "Description", "Running Status", "Version", "Domain Name", "Static Domain Name",
                   "Ip Balance Strategy", "DNS Ipv4 Mask", "DNS IPv4 Server", "DNS Ipv6 Prefix", "DNS Ipv6 Server"]
    parse_data(context, [data_header], get_info_equalizer_content)


def get_info_equalizer_content(context):
    ret = []
    get_info_equalizer_info(context, ret)
    get_dns_config_info(context, ret)
    return [ret]


def get_dns_config_info(context, ret):
    dns_config_lines = get_command_result_lines(context, "cmd_display_info_equalizer_dns_configuration_info")
    dns_config_dict_list = parse_table_type_cmd_result(dns_config_lines)
    if dns_config_dict_list and dns_config_dict_list[0]:
        dns_config_dict = dns_config_dict_list[0]
        ret.extend([dns_config_dict.get("DNS Ipv4 Mask"), dns_config_dict.get("DNS Ipv4 Server"),
                    dns_config_dict.get("DNS Ipv6 Prefix"), dns_config_dict.get("DNS Ipv6 Server")])
    else:
        ret.extend(["", "", "", ""])


def get_info_equalizer_info(context, ret):
    info_equalizer_lines = get_command_result_lines(context, "cmd_display_info_equalizer_info")
    info_equalizer_dict_list = parse_table_type_cmd_result(info_equalizer_lines)
    if info_equalizer_dict_list and info_equalizer_dict_list[0]:
        info_equalizer_dict = info_equalizer_dict_list[0]
        ret.extend(
            [info_equalizer_dict.get("Name"), info_equalizer_dict.get("Description"),
             info_equalizer_dict.get("Running Status"), info_equalizer_dict.get("Version"),
             info_equalizer_dict.get("Domain Name"), info_equalizer_dict.get("Static Domain Name"),
             info_equalizer_dict.get("Ip Balance Strategy")])
    else:
        ret.extend(["", "", "", "", "", "", ""])
